/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.yahoo.vespa.http.client.FeedClient;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

public class JsonReader {
    private static final int maxDocumentSizeChars = 0x3200000;

    private JsonReader() {
    }

    public static void read(InputStream inputStream, FeedClient feedClient, AtomicInteger numSent) {
        try {
            InputStreamJsonElementBuffer jsonElementBuffer = new InputStreamJsonElementBuffer(inputStream);
            try {
                JsonFactory jfactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).build();
                JsonParser jParser = jfactory.createParser((Reader)jsonElementBuffer);
                while (true) {
                    int documentStart = (int)jParser.getCurrentLocation().getCharOffset();
                    String docId = JsonReader.parseOneDocument(jParser);
                    if (docId == null) {
                        int documentEnd = (int)jParser.getCurrentLocation().getCharOffset();
                        int documentLength = documentEnd - documentStart;
                        int maxTruncatedLength = 500;
                        StringBuilder stringBuilder = new StringBuilder(maxTruncatedLength + 3);
                        for (int i = 0; i < Math.min(documentLength, maxTruncatedLength); ++i) {
                            stringBuilder.append(jsonElementBuffer.circular.get(documentStart + i));
                        }
                        if (documentLength > maxTruncatedLength) {
                            stringBuilder.append("...");
                        }
                        throw new IllegalArgumentException("Document is missing ID: '" + stringBuilder.toString() + "'");
                    }
                    CharSequence data = jsonElementBuffer.getJsonAsArray(jParser.getCurrentLocation().getCharOffset());
                    feedClient.stream(docId, data);
                    numSent.incrementAndGet();
                }
            }
            catch (Throwable throwable) {
                try {
                    jsonElementBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException jsonElementBuffer) {
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            throw new UncheckedIOException(ioe);
        }
    }

    private static String parseOneDocument(JsonParser jParser) throws IOException {
        int objectLevel = 0;
        String documentId = null;
        boolean foundObject = false;
        boolean valueIsDocumentId = false;
        while (jParser.nextToken() != null) {
            String tokenAsText = jParser.getText();
            if (valueIsDocumentId) {
                if (documentId != null) {
                    throw new RuntimeException("Several document ids");
                }
                documentId = tokenAsText;
                valueIsDocumentId = false;
            }
            switch (jParser.getCurrentToken()) {
                case START_OBJECT: {
                    foundObject = true;
                    ++objectLevel;
                    break;
                }
                case END_OBJECT: {
                    if (--objectLevel != 0) break;
                    return documentId;
                }
                case FIELD_NAME: {
                    if (objectLevel != 1 || !tokenAsText.equals("put") && !tokenAsText.endsWith("id") && !tokenAsText.endsWith("update") && !tokenAsText.equals("remove")) break;
                    valueIsDocumentId = true;
                    break;
                }
            }
        }
        if (!foundObject) {
            throw new EOFException("No more documents");
        }
        return null;
    }

    private static class InputStreamJsonElementBuffer
    extends InputStreamReader {
        private final CircularCharBuffer circular = new CircularCharBuffer(0x3200000);
        private int processedChars = 0;

        public InputStreamJsonElementBuffer(InputStream inputStream) {
            super(inputStream, StandardCharsets.UTF_8);
        }

        public CharSequence getJsonAsArray(long parserPosition) throws IOException {
            int charSize = (int)parserPosition - this.processedChars;
            int endPosOfJson = this.circular.findLastObjectEnd(charSize);
            int startPosOfJson = this.circular.findNextObjectStart();
            this.processedChars += charSize;
            StringBuilder dataBuffer = new StringBuilder(endPosOfJson - startPosOfJson);
            for (int x = startPosOfJson; x < endPosOfJson; ++x) {
                dataBuffer.append(this.circular.get(x));
            }
            this.circular.advance(charSize);
            return dataBuffer.toString();
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            int length;
            int value = 0;
            for (length = 0; length < len && value != -1; ++length) {
                value = this.read();
                if (value == -1) {
                    return length == 0 ? -1 : length;
                }
                b[off + length] = (char)value;
            }
            return length;
        }

        @Override
        public int read() throws IOException {
            int value = super.read();
            if (value >= 0) {
                this.circular.put((char)value);
            }
            return value;
        }

        private class CircularCharBuffer {
            int readPointer = 0;
            int writePointer = 0;
            final char[] data;
            final int size;

            public CircularCharBuffer(int chars) {
                this.data = new char[chars];
                this.size = chars;
            }

            public int findNextObjectStart() {
                int readerPos = 0;
                while (this.get(readerPos) != '{') {
                    assert (++readerPos <= this.size);
                }
                return readerPos;
            }

            public int findLastObjectEnd(int fromPos) {
                while (this.get(fromPos - 1) != '}') {
                    assert (--fromPos >= 0);
                }
                return fromPos;
            }

            public void put(char dataByte) {
                this.data[this.writePointer] = dataByte;
                ++this.writePointer;
                if (this.writePointer >= this.size) {
                    this.writePointer = 0;
                }
                assert (this.writePointer != this.readPointer);
            }

            public char get(int pos) {
                int readPos = this.readPointer + pos;
                if (readPos >= this.size) {
                    readPos -= this.size;
                }
                assert (readPos != this.writePointer);
                return this.data[readPos];
            }

            public void advance(int end) {
                this.readPointer += end;
                if (this.readPointer >= this.size) {
                    this.readPointer -= this.size;
                }
            }
        }
    }
}

