/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.communication;

import com.yahoo.vespa.http.client.core.Document;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

class DocumentQueue {
    private final Deque<Document> queue;
    private final int maxSize;
    private boolean closed = false;
    private final Clock clock;

    DocumentQueue(int maxSize, Clock clock) {
        this.maxSize = maxSize;
        this.queue = new ArrayDeque<Document>(maxSize);
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Document> removeAllDocuments() {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            ArrayList<Document> allDocs = new ArrayList<Document>();
            while (!this.queue.isEmpty()) {
                allDocs.add(this.queue.poll());
            }
            this.queue.notifyAll();
            return allDocs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(Document document, boolean calledFromIoThreadGroup) throws InterruptedException {
        document.setQueueInsertTime(this.clock.instant());
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            while (!this.closed && this.queue.size() >= this.maxSize && !calledFromIoThreadGroup) {
                this.queue.wait();
            }
            if (this.closed) {
                throw new IllegalStateException("Cannot add elements to closed queue.");
            }
            this.queue.add(document);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document poll(long timeout, TimeUnit unit) throws InterruptedException {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            long remainingToWait = unit.toMillis(timeout);
            while (this.queue.isEmpty()) {
                long startTime = this.clock.millis();
                this.queue.wait(remainingToWait);
                if ((remainingToWait -= this.clock.millis() - startTime) > 0L) continue;
                break;
            }
            Document document = this.queue.poll();
            this.queue.notifyAll();
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document poll() {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            Document document = this.queue.poll();
            this.queue.notifyAll();
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            this.queue.clear();
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean close() {
        boolean previousState;
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            previousState = this.closed;
            this.closed = true;
            this.queue.notifyAll();
        }
        return previousState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Document> pollDocumentIfTimedoutInQueue(Duration localQueueTimeOut) {
        Deque<Document> deque = this.queue;
        synchronized (deque) {
            if (this.queue.isEmpty()) {
                return Optional.empty();
            }
            Document document = this.queue.peek();
            if (document.getQueueInsertTime().plus(localQueueTimeOut).isBefore(this.clock.instant())) {
                return Optional.ofNullable(this.queue.poll());
            }
            return Optional.empty();
        }
    }
}

