/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.communication;

import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.core.Document;
import com.yahoo.vespa.http.client.core.ErrorCode;
import com.yahoo.vespa.http.client.core.OperationStatus;
import com.yahoo.vespa.http.client.core.ServerResponseException;
import com.yahoo.vespa.http.client.core.communication.GatewayConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DryRunGatewayConnection
implements GatewayConnection {
    private final Endpoint endpoint;
    private final Clock clock;
    private Instant connectionTime = null;
    private Instant lastPollTime = null;
    private boolean hold = false;
    private final List<Document> held = new ArrayList<Document>();
    private ServerResponseException throwThisOnHandshake = null;
    private IOException throwThisOnWrite = null;

    public DryRunGatewayConnection(Endpoint endpoint, Clock clock) {
        this.endpoint = endpoint;
        this.clock = clock;
    }

    @Override
    public synchronized InputStream write(List<Document> docs) throws IOException {
        if (this.throwThisOnWrite != null) {
            throw this.throwThisOnWrite;
        }
        if (this.hold) {
            this.held.addAll(docs);
            return new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
        }
        StringBuilder result = new StringBuilder();
        for (Document doc : this.held) {
            result.append(this.okResponse(doc).render());
        }
        this.held.clear();
        for (Document doc : docs) {
            result.append(this.okResponse(doc).render());
        }
        return new ByteArrayInputStream(result.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public synchronized InputStream poll() throws IOException {
        this.lastPollTime = this.clock.instant();
        return this.write(new ArrayList<Document>());
    }

    @Override
    public synchronized Instant lastPollTime() {
        return this.lastPollTime;
    }

    @Override
    public synchronized InputStream drain() throws IOException {
        return this.write(new ArrayList<Document>());
    }

    @Override
    public synchronized boolean connect() {
        this.connectionTime = this.clock.instant();
        return true;
    }

    @Override
    public synchronized Instant connectionTime() {
        return this.connectionTime;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public synchronized void handshake() throws ServerResponseException {
        if (this.throwThisOnHandshake != null) {
            throw this.throwThisOnHandshake;
        }
    }

    @Override
    public synchronized void close() {
    }

    public synchronized void hold(boolean hold) {
        this.hold = hold;
    }

    public synchronized List<Document> held() {
        return Collections.unmodifiableList(this.held);
    }

    public synchronized void throwOnWrite(IOException throwThisOnWrite) {
        this.throwThisOnWrite = throwThisOnWrite;
    }

    public synchronized void throwOnHandshake(ServerResponseException throwThisOnHandshake) {
        this.throwThisOnHandshake = throwThisOnHandshake;
    }

    private OperationStatus okResponse(Document document) {
        return new OperationStatus("ok", document.getOperationId(), ErrorCode.OK, false, "");
    }
}

