/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.communication;

import java.util.concurrent.ThreadLocalRandom;

public class GatewayThrottler {
    private long backOffTimeMs = 0L;
    private final long maxSleepTimeMs;

    public GatewayThrottler(long maxSleepTimeMs) {
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    public void handleCall(int transientErrors) {
        this.backOffTimeMs = transientErrors > 0 ? Math.min(this.maxSleepTimeMs, this.backOffTimeMs + (long)this.distribute(100)) : Math.max(0L, this.backOffTimeMs - (long)this.distribute(10));
        this.sleepMs(this.backOffTimeMs);
    }

    protected void sleepMs(long sleepTime) {
        try {
            if (this.backOffTimeMs > 0L) {
                Thread.sleep(this.backOffTimeMs);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int distribute(int expected) {
        double factor = 0.5 + ThreadLocalRandom.current().nextDouble();
        Double result = (double)expected * factor;
        return result.intValue();
    }
}

