/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.runner;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.format.DataFormatDetector;
import com.fasterxml.jackson.core.format.DataFormatMatcher;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;

public class FormatInputStream {
    private InputStream inputStream;
    private final Format format;

    public FormatInputStream(InputStream stream, Optional<String> inputFile, boolean addRootElementToXml) throws IOException {
        DataFormatMatcher formatMatcher;
        DataFormatDetector dataFormatDetector = new DataFormatDetector(new JsonFactory[]{new JsonFactory(), new XmlFactory()});
        if (inputFile.isPresent()) {
            try (FileInputStream fileInputStream = new FileInputStream(inputFile.get());){
                formatMatcher = dataFormatDetector.findFormat((InputStream)fileInputStream);
            }
            this.inputStream = new FileInputStream(inputFile.get());
        } else {
            if (stream.available() == 0) {
                System.out.println("No data in stream yet and no file specified, waiting for data.");
            }
            this.inputStream = stream.markSupported() ? stream : new BufferedInputStream(stream);
            this.inputStream.mark(64);
            formatMatcher = dataFormatDetector.findFormat(this.inputStream);
            this.inputStream.reset();
        }
        if (addRootElementToXml) {
            this.inputStream = FormatInputStream.addVespafeedTag(this.inputStream);
            this.format = Format.XML;
            return;
        }
        if (formatMatcher.getMatchStrength() == MatchStrength.INCONCLUSIVE || formatMatcher.getMatchStrength() == MatchStrength.NO_MATCH) {
            throw new IllegalArgumentException("Could not detect input format");
        }
        switch (formatMatcher.getMatchedFormatName().toLowerCase()) {
            case "json": {
                this.format = Format.JSON;
                break;
            }
            case "xml": {
                this.format = Format.XML;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data format");
            }
        }
    }

    private static InputStream addVespafeedTag(InputStream inputStream) {
        return new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream("<vespafeed>".getBytes()), inputStream, new ByteArrayInputStream("</vespafeed>".getBytes()))));
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Format getFormat() {
        return this.format;
    }

    public static enum Format {
        JSON,
        XML;

    }
}

