/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.runner;

import com.yahoo.vespa.http.client.FeedClient;
import com.yahoo.vespa.http.client.FeedClientFactory;
import com.yahoo.vespa.http.client.SimpleLoggerResultCallback;
import com.yahoo.vespa.http.client.core.JsonReader;
import com.yahoo.vespa.http.client.core.XmlFeedReader;
import com.yahoo.vespa.http.client.runner.CommandLineArguments;
import com.yahoo.vespa.http.client.runner.FormatInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class Runner {
    public static long send(FeedClient feedClient, InputStream inputStream, boolean isJson, AtomicInteger numSent, boolean verbose) {
        Clock clock = Clock.systemUTC();
        if (verbose) {
            System.err.println("Now sending data.");
        }
        long sendStartTime = clock.millis();
        if (isJson) {
            JsonReader.read(inputStream, feedClient, numSent);
        } else {
            try {
                XmlFeedReader.read(inputStream, feedClient, numSent);
            }
            catch (Exception e) {
                System.err.println("Stopped reading feed, got problems with XML: " + e.getMessage());
            }
        }
        long sendTotalTime = clock.millis() - sendStartTime;
        if (verbose) {
            System.err.println("Waiting for all results, sent " + numSent.get() + " docs.");
        }
        feedClient.close();
        if (verbose) {
            System.err.println("Session closed.");
        }
        return sendTotalTime;
    }

    public static void main(String[] args) throws IOException {
        CommandLineArguments commandLineArgs = CommandLineArguments.build(args);
        if (commandLineArgs == null) {
            System.exit(1);
        }
        FormatInputStream formatInputStream = new FormatInputStream(System.in, Optional.ofNullable(commandLineArgs.getFile()), commandLineArgs.getAddRootElementToXml());
        int intervalOfLogging = commandLineArgs.getVerbose() ? commandLineArgs.getWhenVerboseEnabledPrintMessageForEveryXDocuments() : Integer.MAX_VALUE;
        AtomicInteger numSent = new AtomicInteger(0);
        SimpleLoggerResultCallback callback = new SimpleLoggerResultCallback(numSent, intervalOfLogging, commandLineArgs.getIgnoreConditionNotMet());
        FeedClient feedClient = FeedClientFactory.create(commandLineArgs.createSessionParams(formatInputStream.getFormat() == FormatInputStream.Format.JSON), callback);
        long sendTotalTimeMs = Runner.send(feedClient, formatInputStream.getInputStream(), formatInputStream.getFormat() == FormatInputStream.Format.JSON, numSent, commandLineArgs.getVerbose());
        if (commandLineArgs.getVerbose()) {
            System.err.println(feedClient.getStatsAsJson());
            double transferTimeSec = (double)sendTotalTimeMs / 1000.0;
            if (transferTimeSec > 0.0) {
                System.err.printf("Docs/sec %.3f%n", (double)numSent.get() / transferTimeSec);
            }
            if (commandLineArgs.getFile() != null) {
                double fileSizeMb = (double)new File(commandLineArgs.getFile()).length() / 1024.0 / 1024.0;
                System.err.println("Sent " + fileSizeMb + " MB in " + transferTimeSec + " seconds.");
                System.err.println("Speed: " + fileSizeMb / transferTimeSec * 8.0 + " Mbits/sec, + HTTP overhead (not taking compression into account)");
            }
        }
        callback.printProgress();
    }
}

