/**
 * This file is generated from a config definition file.
 * ------------   D O   N O T   E D I T !   ------------
 */

package com.yahoo.document.restapi;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of document-operation-executor
 *
 * Copyright Yahoo. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumentOperationExecutorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "a3e2eb3c5495a0452831d1849f7d302d";
  public final static String CONFIG_DEF_NAME = "document-operation-executor";
  public final static String CONFIG_DEF_NAMESPACE = "com.yahoo.document.restapi";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=com.yahoo.document.restapi",
    "resendDelayMillis int default=10",
    "maxThrottled int default=4096"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer resendDelayMillis = null;
    private Integer maxThrottled = null;

    public Builder() { }

    public Builder(DocumentOperationExecutorConfig config) {
      resendDelayMillis(config.resendDelayMillis());
      maxThrottled(config.maxThrottled());
    }

    private Builder override(Builder __superior) {
      if (__superior.resendDelayMillis != null)
        resendDelayMillis(__superior.resendDelayMillis);
      if (__superior.maxThrottled != null)
        maxThrottled(__superior.maxThrottled);
      return this;
    }

    public Builder resendDelayMillis(int __value) {
      resendDelayMillis = __value;
      return this;
    }

    private Builder resendDelayMillis(String __value) {
      return resendDelayMillis(Integer.valueOf(__value));
    }

    public Builder maxThrottled(int __value) {
      maxThrottled = __value;
      return this;
    }

    private Builder maxThrottled(String __value) {
      return maxThrottled(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumentOperationExecutorConfig build() {
      return new DocumentOperationExecutorConfig(this);
    }

  }

  // Duration for which resender thread sleeps after an operation is throttled
  private final IntegerNode resendDelayMillis;
  // Bound on number of document operations to keep in retry queue — further operations are rejected
  private final IntegerNode maxThrottled;

  public DocumentOperationExecutorConfig(Builder builder) {
    this(builder, true);
  }

  private DocumentOperationExecutorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "document-operation-executor must be initialized: " + builder.__uninitialized);

    resendDelayMillis = (builder.resendDelayMillis == null) ?
        new IntegerNode(10) : new IntegerNode(builder.resendDelayMillis);
    maxThrottled = (builder.maxThrottled == null) ?
        new IntegerNode(4096) : new IntegerNode(builder.maxThrottled);
  }

  /**
   * @return document-operation-executor.resendDelayMillis
   */
  public int resendDelayMillis() {
    return resendDelayMillis.value();
  }

  /**
   * @return document-operation-executor.maxThrottled
   */
  public int maxThrottled() {
    return maxThrottled.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumentOperationExecutorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("document-operation-executor");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
