/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.DynamicThrottlePolicy;
import com.yahoo.messagebus.Message;
import com.yahoo.vespa.http.server.MetricNames;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class InstrumentedThrottlePolicy
extends DynamicThrottlePolicy {
    private static final Logger log = Logger.getLogger(InstrumentedThrottlePolicy.class.getName());
    private final AtomicInteger previousMaxPending = new AtomicInteger(Integer.MIN_VALUE);
    private final Metric metric;

    @Inject
    InstrumentedThrottlePolicy(Metric metric) {
        this.setResizeRate(2.0);
        this.metric = metric;
    }

    public boolean canSend(Message message, int pendingCount) {
        boolean canSend = super.canSend(message, pendingCount);
        int currentValue = this.getMaxPendingCount();
        int previousValue = this.previousMaxPending.getAndSet(currentValue);
        if (previousValue != currentValue) {
            this.metric.set(MetricNames.MBUS_WINDOW_SIZE, (Number)currentValue, null);
            log.fine(() -> "Max pending count updated from " + previousValue + " to " + currentValue);
        }
        return canSend;
    }
}

