/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.client.openai;

import ai.vespa.llm.LanguageModel;
import ai.vespa.llm.completion.Completion;
import ai.vespa.llm.completion.Prompt;
import com.yahoo.api.annotations.Beta;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Beta
public class OpenAiClient
implements LanguageModel {
    private static final String DATA_FIELD = "data: ";
    private final String token;
    private final String model;
    private final double temperature;
    private final long maxTokens;
    private final HttpClient httpClient;

    private OpenAiClient(Builder builder) {
        this.token = builder.token;
        this.model = builder.model;
        this.temperature = builder.temperature;
        this.maxTokens = builder.maxTokens;
        this.httpClient = HttpClient.newBuilder().build();
    }

    @Override
    public List<Completion> complete(Prompt prompt) {
        try {
            HttpResponse<byte[]> httpResponse = this.httpClient.send(this.toRequest(prompt), HttpResponse.BodyHandlers.ofByteArray());
            Cursor response = SlimeUtils.jsonToSlime(httpResponse.body()).get();
            if (httpResponse.statusCode() != 200) {
                throw new IllegalArgumentException(SlimeUtils.toJson(response));
            }
            return this.toCompletions(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Completion.FinishReason> completeAsync(Prompt prompt, Consumer<Completion> consumer) {
        try {
            HttpRequest request = this.toRequest(prompt, true);
            CompletableFuture<HttpResponse<Stream<String>>> futureResponse = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofLines());
            CompletableFuture<Completion.FinishReason> completionFuture = new CompletableFuture<Completion.FinishReason>();
            futureResponse.thenAcceptAsync(response -> {
                try {
                    int responseCode = response.statusCode();
                    if (responseCode != 200) {
                        throw new IllegalArgumentException("Received code " + responseCode + ": " + ((Stream)response.body()).collect(Collectors.joining()));
                    }
                    Stream lines = (Stream)response.body();
                    lines.forEach(line -> {
                        if (line.startsWith(DATA_FIELD)) {
                            Cursor root = SlimeUtils.jsonToSlime(line.substring(DATA_FIELD.length())).get();
                            Completion completion = this.toCompletions(root, "delta").get(0);
                            consumer.accept(completion);
                            if (!completion.finishReason().equals((Object)Completion.FinishReason.none)) {
                                completionFuture.complete(completion.finishReason());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    completionFuture.completeExceptionally(e);
                }
            });
            return completionFuture;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpRequest toRequest(Prompt prompt) throws IOException, URISyntaxException {
        return this.toRequest(prompt, false);
    }

    private HttpRequest toRequest(Prompt prompt, boolean stream) throws IOException, URISyntaxException {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("model", this.model);
        root.setDouble("temperature", this.temperature);
        root.setBool("stream", stream);
        root.setLong("n", 1L);
        if (this.maxTokens > 0L) {
            root.setLong("max_tokens", this.maxTokens);
        }
        Cursor messagesArray = root.setArray("messages");
        Cursor messagesObject = messagesArray.addObject();
        messagesObject.setString("role", "user");
        messagesObject.setString("content", prompt.asString());
        return HttpRequest.newBuilder(new URI("https://api.openai.com/v1/chat/completions")).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.token).POST(HttpRequest.BodyPublishers.ofByteArray(SlimeUtils.toJsonBytes(slime))).build();
    }

    private List<Completion> toCompletions(Inspector response) {
        return this.toCompletions(response, "message");
    }

    private List<Completion> toCompletions(Inspector response, String field) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        response.field("choices").traverse((__, choice) -> completions.add(this.toCompletion(choice, field)));
        return completions;
    }

    private Completion toCompletion(Inspector choice, String field) {
        String content = choice.field(field).field("content").asString();
        Completion.FinishReason finishReason = this.toFinishReason(choice.field("finish_reason").asString());
        return new Completion(content, finishReason);
    }

    private Completion.FinishReason toFinishReason(String finishReasonString) {
        return switch (finishReasonString) {
            case "length" -> Completion.FinishReason.length;
            case "stop" -> Completion.FinishReason.stop;
            case "", "null" -> Completion.FinishReason.none;
            default -> throw new IllegalStateException("Unknown OpenAi completion finish reason '" + finishReasonString + "'");
        };
    }

    public static class Builder {
        private final String token;
        private String model = "gpt-3.5-turbo";
        private double temperature = 0.0;
        private long maxTokens = 0L;

        public Builder(String token) {
            this.token = token;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxTokens(long maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }
    }
}

