/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io.reader;

import com.yahoo.api.annotations.Beta;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.List;

@Beta
public class NamedReader
extends Reader {
    private final String name;
    private final Reader reader;

    public NamedReader(String name, Reader reader) {
        this.name = name;
        this.reader = reader;
    }

    public String getName() {
        return this.name;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String toString() {
        return this.name;
    }

    public static Reader nullReader() {
        return new NamedReader("nullReader", Reader.nullReader());
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        return this.reader.read(charBuffer);
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public int read(char[] chars) throws IOException {
        return this.reader.read(chars);
    }

    @Override
    public int read(char[] chars, int i, int i1) throws IOException {
        return this.reader.read(chars, i, i1);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.reader.skip(l);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public void mark(int i) throws IOException {
        this.reader.mark(i);
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long transferTo(Writer out) throws IOException {
        return this.reader.transferTo(out);
    }

    public static void closeAll(List<NamedReader> readers) {
        if (readers == null) {
            return;
        }
        for (Reader reader : readers) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

