/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.ScalarFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class DynamicTensor<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final TensorType type;

    DynamicTensor(TensorType type) {
        this.type = type;
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        return this.type;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of();
    }

    public abstract List<TensorFunction<NAMETYPE>> cellGeneratorFunctions();

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 0) {
            throw new IllegalArgumentException("Dynamic tensors must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return this;
    }

    TensorType type() {
        return this.type;
    }

    abstract String contentToString(ToStringContext<NAMETYPE> var1);

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return this.type().toString() + ":" + this.contentToString(context);
    }

    public static <NAMETYPE extends Name> DynamicTensor<NAMETYPE> from(TensorType type, Map<TensorAddress, ScalarFunction<NAMETYPE>> cells) {
        return new MappedDynamicTensor<NAMETYPE>(type, cells);
    }

    public static <NAMETYPE extends Name> DynamicTensor<NAMETYPE> from(TensorType type, List<ScalarFunction<NAMETYPE>> cells) {
        return new IndexedDynamicTensor<NAMETYPE>(type, cells);
    }

    private static class MappedDynamicTensor<NAMETYPE extends Name>
    extends DynamicTensor<NAMETYPE> {
        private final ImmutableMap<TensorAddress, ScalarFunction<NAMETYPE>> cells;

        MappedDynamicTensor(TensorType type, Map<TensorAddress, ScalarFunction<NAMETYPE>> cells) {
            super(type);
            this.cells = ImmutableMap.copyOf(cells);
        }

        @Override
        public List<TensorFunction<NAMETYPE>> cellGeneratorFunctions() {
            ArrayList result = new ArrayList();
            for (ScalarFunction fun : this.cells.values()) {
                fun.asTensorFunction().ifPresent(tf -> result.add((TensorFunction)tf));
            }
            return result;
        }

        @Override
        public TensorFunction<NAMETYPE> withTransformedFunctions(Function<ScalarFunction<NAMETYPE>, ScalarFunction<NAMETYPE>> transformer) {
            LinkedHashMap<TensorAddress, ScalarFunction<NAMETYPE>> transformedCells = new LinkedHashMap<TensorAddress, ScalarFunction<NAMETYPE>>();
            for (Map.Entry orig : this.cells.entrySet()) {
                ScalarFunction<NAMETYPE> transformed = transformer.apply((ScalarFunction)orig.getValue());
                transformedCells.put((TensorAddress)orig.getKey(), transformed);
            }
            return new MappedDynamicTensor<NAMETYPE>(this.type(), transformedCells);
        }

        @Override
        public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
            Tensor.Builder builder = Tensor.Builder.of(this.type());
            for (Map.Entry cell : this.cells.entrySet()) {
                builder.cell((TensorAddress)cell.getKey(), (double)((ScalarFunction)cell.getValue()).apply(context));
            }
            return builder.build();
        }

        @Override
        String contentToString(ToStringContext<NAMETYPE> context) {
            if (this.type().dimensions().isEmpty()) {
                if (this.cells.isEmpty()) {
                    return "{}";
                }
                return "{{}:" + ((ScalarFunction)this.cells.values().iterator().next()).toString(context) + "}";
            }
            StringBuilder b = new StringBuilder("{");
            for (Map.Entry cell : this.cells.entrySet()) {
                b.append(((TensorAddress)cell.getKey()).toString(this.type())).append(":").append(((ScalarFunction)cell.getValue()).toString(context));
                b.append(",");
            }
            if (b.length() > 1) {
                b.setLength(b.length() - 1);
            }
            b.append("}");
            return b.toString();
        }

        @Override
        public int hashCode() {
            return Objects.hash("mappedDynamicTensor", this.type(), this.cells);
        }
    }

    private static class IndexedDynamicTensor<NAMETYPE extends Name>
    extends DynamicTensor<NAMETYPE> {
        private final List<ScalarFunction<NAMETYPE>> cells;

        IndexedDynamicTensor(TensorType type, List<ScalarFunction<NAMETYPE>> cells) {
            super(type);
            if (!type.dimensions().stream().allMatch(d -> d.type() == TensorType.Dimension.Type.indexedBound)) {
                throw new IllegalArgumentException("A dynamic tensor can only be created from a list if the type has only indexed, bound dimensions, but this has " + type);
            }
            this.cells = List.copyOf(cells);
        }

        @Override
        public List<TensorFunction<NAMETYPE>> cellGeneratorFunctions() {
            ArrayList result = new ArrayList();
            for (ScalarFunction<NAMETYPE> fun : this.cells) {
                fun.asTensorFunction().ifPresent(tf -> result.add((TensorFunction)tf));
            }
            return result;
        }

        @Override
        public TensorFunction<NAMETYPE> withTransformedFunctions(Function<ScalarFunction<NAMETYPE>, ScalarFunction<NAMETYPE>> transformer) {
            ArrayList<ScalarFunction<NAMETYPE>> transformedCells = new ArrayList<ScalarFunction<NAMETYPE>>();
            for (ScalarFunction<NAMETYPE> orig : this.cells) {
                ScalarFunction<NAMETYPE> transformed = transformer.apply(orig);
                transformedCells.add(transformed);
            }
            return new IndexedDynamicTensor<NAMETYPE>(this.type(), transformedCells);
        }

        @Override
        public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
            IndexedTensor.BoundBuilder builder = (IndexedTensor.BoundBuilder)Tensor.Builder.of(this.type());
            for (int i = 0; i < this.cells.size(); ++i) {
                builder.cellByDirectIndex((long)i, this.cells.get(i).apply(context));
            }
            return builder.build();
        }

        @Override
        String contentToString(ToStringContext<NAMETYPE> context) {
            if (this.type().dimensions().isEmpty()) {
                if (this.cells.isEmpty()) {
                    return "{}";
                }
                return "{" + this.cells.get(0).toString(context) + "}";
            }
            IndexedTensor.Indexes indexes = IndexedTensor.Indexes.of(this.type());
            StringBuilder b = new StringBuilder("{");
            for (ScalarFunction<NAMETYPE> cell : this.cells) {
                indexes.next();
                b.append(indexes.toAddress().toString(this.type())).append(":").append(cell.toString(context));
                b.append(",");
            }
            if (b.length() > 1) {
                b.setLength(b.length() - 1);
            }
            b.append("}");
            return b.toString();
        }

        @Override
        public int hashCode() {
            return Objects.hash("indexedDynamicTensor", this.type(), this.cells);
        }
    }
}

