/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access.helpers;

import com.yahoo.collections.Hashlet;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.ObjectTraverser;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.Value;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MatchFeatureData {
    private final Hashlet<String, Integer> hashlet = new Hashlet();

    public MatchFeatureData(List<String> keys) {
        this.hashlet.reserve(keys.size());
        int i = 0;
        for (String key : keys) {
            this.hashlet.put(key, i++);
        }
    }

    public HitValue addHit() {
        return new HitValue(this.hashlet);
    }

    public static class HitValue
    extends Value {
        private final Hashlet<String, Integer> hashlet;
        private final byte[][] dataValues;
        private final double[] doubleValues;

        @Override
        public Type type() {
            return Type.OBJECT;
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public int fieldCount() {
            return this.hashlet.size();
        }

        @Override
        public void traverse(ObjectTraverser ot) {
            for (int i = 0; i < this.hashlet.size(); ++i) {
                String fn = this.hashlet.key(i);
                int offset = this.hashlet.value(i);
                ot.field(fn, this.valueAt(offset));
            }
        }

        @Override
        public Inspector field(String name) {
            int offset = this.hashlet.getIndexOfKey(name);
            if (offset < 0) {
                return HitValue.invalid();
            }
            return this.valueAt(offset);
        }

        @Override
        public Iterable<Map.Entry<String, Inspector>> fields() {
            ArrayList<Map.Entry<String, Inspector>> list = new ArrayList<Map.Entry<String, Inspector>>(this.hashlet.size());
            for (int i = 0; i < this.hashlet.size(); ++i) {
                String fn = this.hashlet.key(i);
                int offset = this.hashlet.value(i);
                list.add(new AbstractMap.SimpleEntry<String, Inspector>(fn, this.valueAt(offset)));
            }
            return list;
        }

        private HitValue(Hashlet<String, Integer> hashlet) {
            this.hashlet = hashlet;
            this.dataValues = new byte[hashlet.size()][];
            this.doubleValues = new double[hashlet.size()];
        }

        public void set(int index, byte[] data) {
            this.dataValues[index] = data;
        }

        public void set(int index, double value) {
            this.doubleValues[index] = value;
        }

        private Inspector valueAt(int index) {
            if (this.dataValues[index] != null) {
                return new Value.DataValue(this.dataValues[index]);
            }
            return new Value.DoubleValue(this.doubleValues[index]);
        }

        public HitValue subsetFilter(Function<Hashlet<String, Integer>, Hashlet<String, Integer>> filter) {
            return new HitValue(filter.apply(this.hashlet), this.dataValues, this.doubleValues);
        }

        private HitValue(Hashlet<String, Integer> hashlet, byte[][] dataValues, double[] doubleValues) {
            this.hashlet = hashlet;
            this.dataValues = dataValues;
            this.doubleValues = doubleValues;
        }
    }
}

