/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.geo;

public class ZCurve {
    public static long encode(int x, int y) {
        long xl = x;
        long yl = y;
        long rx = (xl & 0xFFFF0000L) << 16 | xl & 0xFFFFL;
        long ry = (yl & 0xFFFF0000L) << 16 | yl & 0xFFFFL;
        rx = (rx & 0xFF00FF00FF00FF00L) << 8 | rx & 0xFF00FF00FF00FFL;
        ry = (ry & 0xFF00FF00FF00FF00L) << 8 | ry & 0xFF00FF00FF00FFL;
        rx = (rx & 0xF0F0F0F0F0F0F0F0L) << 4 | rx & 0xF0F0F0F0F0F0F0FL;
        ry = (ry & 0xF0F0F0F0F0F0F0F0L) << 4 | ry & 0xF0F0F0F0F0F0F0FL;
        rx = (rx & 0xCCCCCCCCCCCCCCCCL) << 2 | rx & 0x3333333333333333L;
        ry = (ry & 0xCCCCCCCCCCCCCCCCL) << 2 | ry & 0x3333333333333333L;
        rx = (rx & 0xAAAAAAAAAAAAAAAAL) << 1 | rx & 0x5555555555555555L;
        ry = (ry & 0xAAAAAAAAAAAAAAAAL) << 1 | ry & 0x5555555555555555L;
        return rx | ry << 1;
    }

    public static int[] decode(long z) {
        int[] xy = new int[2];
        long xl = z & 0x5555555555555555L;
        long yl = z & 0xAAAAAAAAAAAAAAAAL;
        xl = (xl & 0xCCCCCCCCCCCCCCCCL) >> 1 | xl & 0x3333333333333333L;
        yl = (yl & 0xCCCCCCCCCCCCCCCCL) >> 1 | yl & 0x3333333333333333L;
        xl = (xl & 0xF0F0F0F0F0F0F0F0L) >> 2 | xl & 0xF0F0F0F0F0F0F0FL;
        yl = (yl & 0xF0F0F0F0F0F0F0F0L) >> 2 | yl & 0xF0F0F0F0F0F0F0FL;
        xl = (xl & 0xFF00FF00FF00FF00L) >> 4 | xl & 0xFF00FF00FF00FFL;
        yl = (yl & 0xFF00FF00FF00FF00L) >> 4 | yl & 0xFF00FF00FF00FFL;
        xl = (xl & 0xFFFF0000FFFF0000L) >> 8 | xl & 0xFFFF0000FFFFL;
        yl = (yl & 0xFFFF0000FFFF0000L) >> 8 | yl & 0xFFFF0000FFFFL;
        xl = (xl & 0xFFFFFFFF00000000L) >> 16 | xl & 0xFFFFFFFFL;
        yl = (yl & 0xFFFFFFFF00000000L) >> 16 | yl & 0xFFFFFFFFL;
        xy[0] = (int)xl;
        xy[1] = (int)(yl >> 1);
        return xy;
    }

    public static long encode_slow(int x, int y) {
        long bit;
        int i;
        long z = 0L;
        long xl = x;
        long yl = y;
        long mask = 1L;
        for (i = 0; i < 32; ++i) {
            bit = xl << i & mask;
            z |= bit;
            mask <<= 2;
        }
        mask = 2L;
        for (i = 1; i <= 32; ++i) {
            bit = yl << i & mask;
            z |= bit;
            mask <<= 2;
        }
        return z;
    }

    public static int[] decode_slow(long z) {
        long bit;
        int i;
        int[] xy = new int[2];
        long xl = 0L;
        long yl = 0L;
        long mask = 1L;
        for (i = 0; i < 32; ++i) {
            bit = z >> i & mask;
            xl |= bit;
            mask <<= 1;
        }
        mask = 1L;
        for (i = 1; i <= 32; ++i) {
            bit = z >> i & mask;
            yl |= bit;
            mask <<= 1;
        }
        xy[0] = (int)xl;
        xy[1] = (int)yl;
        return xy;
    }

    public static String toFullBinaryString(long l) {
        StringBuilder s = new StringBuilder(64);
        for (int i = 0; i < Long.numberOfLeadingZeros(l); ++i) {
            s.append('0');
        }
        if (l == 0L) {
            s.deleteCharAt(0);
        }
        s.append(Long.toBinaryString(l));
        return s.toString();
    }
}

