/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.protect;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public final class Process {
    private static final AtomicBoolean alreadyShuttingDown = new AtomicBoolean(false);
    private static final AtomicBoolean busyDumpingThreads = new AtomicBoolean(false);
    private static final Logger log = Logger.getLogger(Process.class.getName());

    public static void logAndDie(String message) {
        Process.logAndDie(message, null);
    }

    public static void logAndDie(String message, boolean dumpThreads) {
        Process.logAndDie(message, null, dumpThreads);
    }

    public static void logAndDie(String message, Throwable thrown) {
        Process.logAndDie(message, thrown, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAndDie(String message, Throwable thrown, boolean dumpThreads) {
        boolean shutDownInProgress = alreadyShuttingDown.getAndSet(true);
        try {
            if (thrown != null) {
                log.log(Level.SEVERE, message, thrown);
            } else {
                log.log(Level.SEVERE, message);
            }
            log.log(Level.INFO, "About to shut down.");
            if (dumpThreads) {
                Process.dumpThreads();
            }
        }
        finally {
            if (!shutDownInProgress) {
                try {
                    Runtime.getRuntime().halt(1);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Runtime.halt rejected. Throwing an error.");
                    throw new ShutdownError("Shutdown requested, but failed to shut down");
                }
            } else {
                log.log(Level.WARNING, "Shutdown already in progress. Will just let death come upon us normally.");
            }
        }
    }

    public static void dumpHeap(String filePath, boolean live) {
        log.log(Level.INFO, "Will dump the heap to '" + filePath + "', with the live = " + live);
        try {
            Process.getHotspotMXBean().dumpHeap(filePath, live);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed writing heap dump:", e);
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMXBean() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        return ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
    }

    public static void dumpThreads() {
        boolean alreadyDumpingThreads = busyDumpingThreads.getAndSet(true);
        if (!alreadyDumpingThreads) {
            try {
                log.log(Level.INFO, "Commencing full thread dump for diagnosis.");
                Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
                for (Map.Entry<Thread, StackTraceElement[]> e : allStackTraces.entrySet()) {
                    Thread t = e.getKey();
                    StackTraceElement[] stack = e.getValue();
                    StringBuilder forOneThread = new StringBuilder();
                    forOneThread.append("Stack for thread: ").append(t.getName()).append(" ").append(t.isDaemon() ? "DAEMON" : "NON-DAEMON").append(": ");
                    for (StackTraceElement s : stack) {
                        forOneThread.append('\n').append(s.toString());
                    }
                    log.log(Level.INFO, forOneThread.toString());
                }
                log.log(Level.INFO, "End of diagnostic thread dump.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            busyDumpingThreads.set(false);
        } else {
            log.log(Level.WARNING, "Thread dump already in progress. Skipping it.");
        }
    }

    public static class ShutdownError
    extends Error {
        public ShutdownError(String message) {
            super(message);
        }
    }
}

