/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;

class IndexedFloatTensor
extends IndexedTensor {
    private final float[] values;

    IndexedFloatTensor(TensorType type, DimensionSizes dimensionSizes, float[] values) {
        super(type, dimensionSizes);
        this.values = values;
    }

    @Override
    public long size() {
        return this.values.length;
    }

    @Override
    public int sizeAsInt() {
        return this.values.length;
    }

    @Override
    public double get(long valueIndex) {
        return this.getFloat(valueIndex);
    }

    @Override
    public float getFloat(long valueIndex) {
        return this.values[(int)valueIndex];
    }

    @Override
    public IndexedTensor withType(TensorType type) {
        this.throwOnIncompatibleType(type);
        return new IndexedFloatTensor(type, this.dimensionSizes(), this.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public static class BoundFloatBuilder
    extends IndexedTensor.BoundBuilder {
        private float[] values;

        BoundFloatBuilder(TensorType type, DimensionSizes sizes) {
            this(type, sizes, new float[(int)sizes.totalSize()]);
        }

        BoundFloatBuilder(TensorType type, DimensionSizes sizes, float[] values) {
            super(type, sizes);
            if (sizes.totalSize() != (long)values.length) {
                throw new IllegalArgumentException("Invalid size(" + values.length + ") of supplied value vector. Type specifies that size should be " + sizes.totalSize());
            }
            this.values = values;
        }

        @Override
        public IndexedTensor.BoundBuilder cell(double value, long ... indexes) {
            return this.cell((float)value, indexes);
        }

        @Override
        public IndexedTensor.BoundBuilder cell(float value, long ... indexes) {
            this.values[(int)IndexedTensor.toValueIndex((long[])indexes, (DimensionSizes)this.sizes())] = value;
            return this;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public IndexedTensor.Builder cell(TensorAddress address, double value) {
            return this.cell(address, (float)value);
        }

        @Override
        public IndexedTensor.Builder cell(TensorAddress address, float value) {
            this.values[(int)IndexedTensor.toValueIndex((TensorAddress)address, (DimensionSizes)this.sizes(), (TensorType)this.type)] = value;
            return this;
        }

        @Override
        public IndexedTensor build() {
            IndexedFloatTensor tensor = new IndexedFloatTensor(this.type, this.sizes(), this.values);
            this.values = null;
            return tensor;
        }

        @Override
        public IndexedTensor.Builder cell(Tensor.Cell cell, double value) {
            return this.cell(cell, (float)value);
        }

        @Override
        public IndexedTensor.Builder cell(Tensor.Cell cell, float value) {
            long directIndex = cell.getDirectIndex();
            if (directIndex >= 0L) {
                this.values[(int)directIndex] = value;
            } else {
                super.cell(cell, value);
            }
            return this;
        }

        @Override
        public void cellByDirectIndex(long index, double value) {
            this.cellByDirectIndex(index, (float)value);
        }

        @Override
        public void cellByDirectIndex(long index, float value) {
            this.values[(int)index] = value;
        }
    }
}

