/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class LazySet<E>
implements Set<E> {
    private Set<E> delegate = this.newEmpty();

    @Override
    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public final boolean add(E e) {
        return this.delegate.add(e);
    }

    @Override
    public final boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public final void clear() {
        this.delegate.clear();
    }

    @Override
    public final int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return obj == this || obj instanceof Set && this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Set<E> newEmpty() {
        return new EmptySet();
    }

    private Set<E> newSingleton(E e) {
        return new SingletonSet(e);
    }

    protected abstract Set<E> newDelegate();

    final Set<E> getDelegate() {
        return this.delegate;
    }

    public static <E> LazySet<E> newHashSet() {
        return new LazySet<E>(){

            @Override
            protected Set<E> newDelegate() {
                return new HashSet();
            }
        };
    }

    class EmptySet
    extends AbstractSet<E> {
        EmptySet() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean add(E e) {
            LazySet.this.delegate = LazySet.this.newSingleton(e);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            switch (c.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.add(c.iterator().next());
                    return true;
                }
            }
            LazySet.this.delegate = LazySet.this.newDelegate();
            LazySet.this.delegate.addAll(c);
            return true;
        }
    }

    class SingletonSet
    extends AbstractSet<E> {
        final E element;

        SingletonSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (this.hasNext) {
                        throw new IllegalStateException();
                    }
                    LazySet.this.delegate = LazySet.this.newEmpty();
                }
            };
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean add(E e) {
            if (this.contains(e)) {
                return false;
            }
            LazySet.this.delegate = LazySet.this.newDelegate();
            LazySet.this.delegate.add(this.element);
            LazySet.this.delegate.add(e);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            switch (c.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.add(c.iterator().next());
                }
            }
            LazySet.this.delegate = LazySet.this.newDelegate();
            LazySet.this.delegate.add(this.element);
            LazySet.this.delegate.addAll(c);
            return true;
        }
    }
}

