/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

final class SymbolTable {
    public static final int INVALID = Integer.MAX_VALUE;
    private static final int[] emptyHash = new int[1];
    private int capacity = 0;
    private int used = 0;
    private String[] names;
    private int[] hash = emptyHash;

    SymbolTable() {
    }

    private int hashSize() {
        return this.capacity + (this.capacity >> 1) - 1;
    }

    private final void rehash() {
        if (this.capacity == 0) {
            this.capacity = 32;
            this.names = new String[this.capacity];
            this.hash = new int[this.hashSize() + (this.capacity << 1)];
            return;
        }
        this.capacity <<= 1;
        String[] n = this.names;
        this.names = new String[this.capacity];
        System.arraycopy(n, 0, this.names, 0, this.used);
        this.hash = new int[this.hashSize() + (this.capacity << 1)];
        int i = 0;
        while (i < this.used) {
            int insertIdx;
            int prev = Math.abs(this.names[i].hashCode() % this.hashSize());
            int entry = this.hash[prev];
            while (entry != 0) {
                prev = entry + 1;
                entry = this.hash[prev];
            }
            this.hash[prev] = insertIdx = this.hashSize() + (i << 1);
            this.hash[insertIdx] = i++;
        }
    }

    final int symbols() {
        return this.used;
    }

    final String inspect(int symbol) {
        return this.names[symbol];
    }

    final int insert(String name) {
        int insertIdx;
        if (this.used == this.capacity) {
            this.rehash();
        }
        int prev = Math.abs(name.hashCode() % this.hashSize());
        int entry = this.hash[prev];
        while (entry != 0) {
            int sym = this.hash[entry];
            if (this.names[sym].equals(name)) {
                return sym;
            }
            prev = entry + 1;
            entry = this.hash[prev];
        }
        this.hash[prev] = insertIdx = this.hashSize() + (this.used << 1);
        this.hash[insertIdx] = this.used;
        this.names[this.used++] = name;
        return this.used - 1;
    }

    final int lookup(String name) {
        int entry = this.hash[Math.abs(name.hashCode() % this.hashSize())];
        while (entry != 0) {
            int sym = this.hash[entry];
            if (this.names[sym].equals(name)) {
                return sym;
            }
            entry = this.hash[entry + 1];
        }
        return Integer.MAX_VALUE;
    }
}

