/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access.simple;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.ObjectTraverser;

public final class JsonRender {
    public static StringBuilder render(Inspectable value, StringBuilder target, boolean compact) {
        return JsonRender.render(value, new StringEncoder(target, compact));
    }

    public static StringBuilder render(Inspectable value, StringEncoder encoder) {
        encoder.encode(value.inspect());
        return encoder.target();
    }

    public static class StringEncoder
    implements ArrayTraverser,
    ObjectTraverser {
        private final StringBuilder out;
        private boolean head = true;
        private final boolean compact;
        private int level = 0;
        static final char[] hex = "0123456789ABCDEF".toCharArray();

        public StringEncoder(StringBuilder out, boolean compact) {
            this.out = out;
            this.compact = compact;
        }

        public void encode(Inspector top) {
            this.encodeValue(top);
            if (!this.compact) {
                this.out.append('\n');
            }
        }

        protected void encodeEMPTY() {
            this.out.append("null");
        }

        protected void encodeBOOL(boolean value) {
            this.out.append(value ? "true" : "false");
        }

        protected void encodeLONG(long value) {
            this.out.append(value);
        }

        protected void encodeDOUBLE(double value) {
            if (Double.isFinite(value)) {
                this.out.append(value);
            } else {
                this.out.append("null");
            }
        }

        protected void encodeSTRING(String value) {
            int pos;
            char[] buf = new char[128];
            int n = pos = 0;
            pos = (char)(pos + 1);
            buf[n] = 34;
            block9: for (char c : value.toCharArray()) {
                if (pos > buf.length - 8) {
                    this.out.append(buf, 0, pos);
                    pos = 0;
                }
                switch (c) {
                    case '\"': {
                        int n2 = pos;
                        pos = (char)(pos + 1);
                        buf[n2] = 92;
                        int n3 = pos;
                        pos = (char)(pos + 1);
                        buf[n3] = 34;
                        continue block9;
                    }
                    case '\\': {
                        int n4 = pos;
                        pos = (char)(pos + 1);
                        buf[n4] = 92;
                        int n5 = pos;
                        pos = (char)(pos + 1);
                        buf[n5] = 92;
                        continue block9;
                    }
                    case '\b': {
                        int n6 = pos;
                        pos = (char)(pos + 1);
                        buf[n6] = 92;
                        int n7 = pos;
                        pos = (char)(pos + 1);
                        buf[n7] = 98;
                        continue block9;
                    }
                    case '\f': {
                        int n8 = pos;
                        pos = (char)(pos + 1);
                        buf[n8] = 92;
                        int n9 = pos;
                        pos = (char)(pos + 1);
                        buf[n9] = 102;
                        continue block9;
                    }
                    case '\n': {
                        int n10 = pos;
                        pos = (char)(pos + 1);
                        buf[n10] = 92;
                        int n11 = pos;
                        pos = (char)(pos + 1);
                        buf[n11] = 110;
                        continue block9;
                    }
                    case '\r': {
                        int n12 = pos;
                        pos = (char)(pos + 1);
                        buf[n12] = 92;
                        int n13 = pos;
                        pos = (char)(pos + 1);
                        buf[n13] = 114;
                        continue block9;
                    }
                    case '\t': {
                        int n14 = pos;
                        pos = (char)(pos + 1);
                        buf[n14] = 92;
                        int n15 = pos;
                        pos = (char)(pos + 1);
                        buf[n15] = 116;
                        continue block9;
                    }
                    default: {
                        if (c > '\u001f') {
                            int n16 = pos;
                            pos = (char)(pos + 1);
                            buf[n16] = c;
                            continue block9;
                        }
                        int n17 = pos;
                        pos = (char)(pos + 1);
                        buf[n17] = 92;
                        int n18 = pos;
                        pos = (char)(pos + 1);
                        buf[n18] = 117;
                        int n19 = pos;
                        pos = (char)(pos + 1);
                        buf[n19] = hex[c >> 12 & 0xF];
                        int n20 = pos;
                        pos = (char)(pos + 1);
                        buf[n20] = hex[c >> 8 & 0xF];
                        int n21 = pos;
                        pos = (char)(pos + 1);
                        buf[n21] = hex[c >> 4 & 0xF];
                        int n22 = pos;
                        pos = (char)(pos + 1);
                        buf[n22] = hex[c & 0xF];
                    }
                }
            }
            int n23 = pos;
            pos = (char)(pos + 1);
            buf[n23] = 34;
            this.out.append(buf, 0, pos);
        }

        protected void encodeDATA(byte[] value) {
            this.out.append('\"');
            this.out.append("0x");
            for (int pos = 0; pos < value.length; ++pos) {
                this.out.append(hex[value[pos] >> 4 & 0xF]);
                this.out.append(hex[value[pos] & 0xF]);
            }
            this.out.append('\"');
        }

        protected void encodeARRAY(Inspector inspector) {
            this.openScope("[");
            StringEncoder at = this;
            inspector.traverse(at);
            this.closeScope("]");
        }

        protected void encodeOBJECT(Inspector inspector) {
            this.openScope("{");
            StringEncoder ot = this;
            inspector.traverse(ot);
            this.closeScope("}");
        }

        private void openScope(String opener) {
            this.out.append(opener);
            ++this.level;
            this.head = true;
        }

        private void closeScope(String closer) {
            --this.level;
            this.separate(false);
            this.out.append(closer);
        }

        private void encodeValue(Inspector inspector) {
            switch (inspector.type()) {
                case EMPTY: {
                    this.encodeEMPTY();
                    return;
                }
                case BOOL: {
                    this.encodeBOOL(inspector.asBool());
                    return;
                }
                case LONG: {
                    this.encodeLONG(inspector.asLong());
                    return;
                }
                case DOUBLE: {
                    this.encodeDOUBLE(inspector.asDouble());
                    return;
                }
                case STRING: {
                    this.encodeSTRING(inspector.asString());
                    return;
                }
                case DATA: {
                    this.encodeDATA(inspector.asData());
                    return;
                }
                case ARRAY: {
                    this.encodeARRAY(inspector);
                    return;
                }
                case OBJECT: {
                    this.encodeOBJECT(inspector);
                    return;
                }
            }
            assert (false) : "Should not be reached";
        }

        private void separate(boolean useComma) {
            if (!this.head && useComma) {
                this.out.append(',');
            } else {
                this.head = false;
            }
            if (!this.compact) {
                this.out.append("\n");
                for (int lvl = 0; lvl < this.level; ++lvl) {
                    this.out.append(" ");
                }
            }
        }

        @Override
        public void entry(int idx, Inspector inspector) {
            this.separate(true);
            this.encodeValue(inspector);
        }

        @Override
        public void field(String name, Inspector inspector) {
            this.separate(true);
            this.encodeSTRING(name);
            this.out.append(':');
            if (!this.compact) {
                this.out.append(' ');
            }
            this.encodeValue(inspector);
        }

        public StringBuilder target() {
            return this.out;
        }
    }
}

