/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.io.WritableByteTransmitter;
import com.yahoo.text.AbstractUtf8Array;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.List;

public final class BufferChain {
    static final int BUFFERSIZE = 4096;
    static final int WATERMARK = 1024;
    static final int MAXBUFFERS = 50;
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private final WritableByteTransmitter endpoint;
    private ByteBuffer current = ByteBuffer.allocate(4096);
    private long appended = 0L;

    public BufferChain(WritableByteTransmitter endpoint) {
        this.endpoint = endpoint;
    }

    public void append(byte b) throws IOException {
        this.makeRoom(1);
        this.current.put(b);
    }

    private final boolean shouldCopy(int length) {
        return length < 1024;
    }

    private final void makeRoom(int length) throws IOException {
        if (this.current.remaining() < length) {
            this.scratch();
        }
    }

    public void append(AbstractUtf8Array v) throws IOException {
        int length = v.getByteLength();
        if (this.shouldCopy(length)) {
            this.makeRoom(length);
            v.writeTo(this.current);
        } else {
            this.append(v.wrap());
        }
    }

    public void append(byte[] alreadyEncoded) throws IOException {
        if (alreadyEncoded.length > 0) {
            this.append(alreadyEncoded, 0, alreadyEncoded.length);
        }
    }

    public void append(byte[] alreadyEncoded, int offset, int length) throws IOException {
        if (this.shouldCopy(length)) {
            this.makeRoom(length);
            this.current.put(alreadyEncoded, offset, length);
        } else {
            this.append(ByteBuffer.wrap(alreadyEncoded, offset, length));
        }
    }

    public void append(ByteBuffer alreadyEncoded) throws IOException {
        if (alreadyEncoded.remaining() == 0) {
            return;
        }
        int length = alreadyEncoded.limit() - alreadyEncoded.position();
        if (this.shouldCopy(length)) {
            this.makeRoom(length);
            this.current.put(alreadyEncoded);
        } else {
            this.scratch();
            this.add(alreadyEncoded);
        }
    }

    private final void add(ByteBuffer buf) {
        this.buffers.add(buf);
        this.appended += (long)buf.limit();
    }

    public void append(CharBuffer toEncode, CharsetEncoder encoder) throws IOException {
        CoderResult overflow;
        do {
            if ((overflow = encoder.encode(toEncode, this.current, true)).isOverflow()) {
                this.scratch();
                continue;
            }
            if (!overflow.isError()) continue;
            try {
                toEncode.get();
            }
            catch (BufferUnderflowException e) {
                break;
            }
        } while (!overflow.isUnderflow());
    }

    private void scratch() throws IOException {
        if (!this.possibleFlush() && this.current.position() != 0) {
            this.current.flip();
            this.add(this.current);
            this.current = ByteBuffer.allocate(4096);
        }
    }

    private boolean possibleFlush() throws IOException {
        if (this.buffers.size() > 50) {
            this.flush();
            return true;
        }
        return false;
    }

    public void flush() throws IOException {
        for (ByteBuffer b : this.buffers) {
            this.endpoint.send(b);
        }
        this.buffers.clear();
        if (this.current.position() > 0) {
            this.current.flip();
            this.appended += (long)this.current.limit();
            this.endpoint.send(this.current);
            this.current = ByteBuffer.allocate(4096);
        }
    }

    public long appended() {
        return this.appended + (long)this.current.position();
    }
}

