/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.DoubleValue;
import com.yahoo.slime.LongValue;
import com.yahoo.slime.NixValue;
import com.yahoo.slime.ObjectValue;
import com.yahoo.slime.SymbolTable;
import com.yahoo.slime.Type;
import com.yahoo.slime.Value;
import com.yahoo.slime.Visitor;

final class ArrayValue
extends Value {
    static final int initial_capacity = 16;
    static final Impl initial_impl = new EmptyImpl();
    private Impl impl = initial_impl;
    private int used = 0;
    private final SymbolTable names;

    public ArrayValue(SymbolTable names) {
        this.names = names;
    }

    @Override
    public Type type() {
        return Type.ARRAY;
    }

    @Override
    public int children() {
        return this.used;
    }

    @Override
    public int entries() {
        return this.used;
    }

    @Override
    public Value entry(int index) {
        return index >= 0 && index < this.used ? this.impl.get(index) : NixValue.invalid();
    }

    @Override
    public void accept(Visitor v) {
        v.visitArray(this);
    }

    @Override
    public void traverse(ArrayTraverser at) {
        for (int i = 0; i < this.used; ++i) {
            at.entry(i, this.impl.get(i));
        }
    }

    @Override
    public Cursor addLong(long value) {
        this.impl.prepareFor(this, Type.LONG);
        return this.impl.add(value, this.used++);
    }

    @Override
    public Cursor addDouble(double value) {
        this.impl.prepareFor(this, Type.DOUBLE);
        return this.impl.add(value, this.used++);
    }

    @Override
    protected Value addLeaf(Value value) {
        this.impl.prepareFor(this, value.type());
        return this.impl.add(value, this.used++);
    }

    @Override
    public Value addArray() {
        return this.addLeaf(new ArrayValue(this.names));
    }

    @Override
    public Value addObject() {
        return this.addLeaf(new ObjectValue(this.names));
    }

    private static interface Impl {
        public void prepareFor(ArrayValue var1, Type var2);

        public Value add(Value var1, int var2);

        public Value add(long var1, int var3);

        public Value add(double var1, int var3);

        public Value get(int var1);
    }

    private static final class EmptyImpl
    implements Impl {
        private EmptyImpl() {
        }

        @Override
        public void prepareFor(ArrayValue self, Type type) {
            self.impl = type == Type.LONG ? new LongImpl() : (type == Type.DOUBLE ? new DoubleImpl() : new GenericImpl(this, 0));
        }

        @Override
        public Value add(Value value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value add(long value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value add(double value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value get(int index) {
            return NixValue.invalid();
        }
    }

    private static final class GenericImpl
    implements Impl {
        private Value[] values;

        GenericImpl(Impl src, int len) {
            int capacity;
            for (capacity = 16; capacity < len + 1; capacity <<= 1) {
            }
            this.values = new Value[capacity];
            for (int i = 0; i < len; ++i) {
                this.values[i] = src.get(i);
            }
        }

        @Override
        public void prepareFor(ArrayValue self, Type type) {
        }

        private static Value[] grow(Value[] arr) {
            Value[] v = new Value[arr.length << 1];
            System.arraycopy(arr, 0, v, 0, arr.length);
            return v;
        }

        @Override
        public Value add(long value, int used) {
            return this.add(new LongValue(value), used);
        }

        @Override
        public Value add(double value, int used) {
            return this.add(new DoubleValue(value), used);
        }

        @Override
        public Value add(Value value, int used) {
            if (used == this.values.length) {
                this.values = GenericImpl.grow(this.values);
            }
            this.values[used] = value;
            return this.get(used);
        }

        @Override
        public Value get(int index) {
            return this.values[index];
        }
    }

    private static final class DoubleImpl
    implements Impl {
        private double[] values = new double[16];

        private DoubleImpl() {
        }

        @Override
        public void prepareFor(ArrayValue self, Type type) {
            if (type != Type.DOUBLE) {
                self.impl = new GenericImpl(this, self.used);
            }
        }

        private static double[] grow(double[] arr) {
            double[] v = new double[arr.length << 1];
            System.arraycopy(arr, 0, v, 0, arr.length);
            return v;
        }

        @Override
        public Value add(Value value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value add(double value, int used) {
            if (used == this.values.length) {
                this.values = DoubleImpl.grow(this.values);
            }
            this.values[used] = value;
            return this.get(used);
        }

        @Override
        public Value add(long value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value get(int index) {
            return new DoubleValue(this.values[index]);
        }
    }

    private static final class LongImpl
    implements Impl {
        private long[] values = new long[16];

        private LongImpl() {
        }

        @Override
        public void prepareFor(ArrayValue self, Type type) {
            if (type != Type.LONG) {
                self.impl = new GenericImpl(this, self.used);
            }
        }

        private static long[] grow(long[] arr) {
            long[] v = new long[arr.length << 1];
            System.arraycopy(arr, 0, v, 0, arr.length);
            return v;
        }

        @Override
        public Value add(Value value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value add(long value, int used) {
            if (used == this.values.length) {
                this.values = LongImpl.grow(this.values);
            }
            this.values[used] = value;
            return this.get(used);
        }

        @Override
        public Value add(double value, int used) {
            return NixValue.invalid();
        }

        @Override
        public Value get(int index) {
            return new LongValue(this.values[index]);
        }
    }
}

