/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated(forRemoval=true)
public class ThreadRobustList<T>
implements Iterable<T> {
    private Object[] items;
    private int next = 0;

    public ThreadRobustList() {
        this(10);
    }

    public ThreadRobustList(int initialCapacity) {
        this.items = new Object[initialCapacity];
    }

    public boolean isEmpty() {
        return this.next == 0;
    }

    public void add(T item) {
        if (item == null) {
            throw new NullPointerException();
        }
        Object[] workItems = this.items;
        if (this.next >= this.items.length) {
            workItems = Arrays.copyOf(workItems, 20 + this.items.length * 2);
            workItems[this.next++] = item;
            this.items = workItems;
        } else {
            workItems[this.next++] = item;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ThreadRobustIterator(this.items);
    }

    private static class ThreadRobustIterator<T>
    implements Iterator<T> {
        final Object[] items;
        int nextIndex = 0;

        ThreadRobustIterator(Object[] items) {
            this.items = items;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (T)this.items[this.nextIndex++];
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex >= this.items.length) {
                return false;
            }
            return this.items[this.nextIndex] != null;
        }
    }
}

