/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.binaryprefix;

import com.yahoo.binaryprefix.BinaryPrefix;

public final class BinaryScaledAmount {
    public final double amount;
    public final BinaryPrefix binaryPrefix;

    public BinaryScaledAmount(double amount, BinaryPrefix binaryPrefix) {
        this.amount = amount;
        this.binaryPrefix = binaryPrefix;
    }

    public BinaryScaledAmount() {
        this(0.0, BinaryPrefix.unit);
    }

    public long as(BinaryPrefix newBinaryPrefix) {
        return Math.round(newBinaryPrefix.convertFrom(this.amount, this.binaryPrefix));
    }

    public boolean equals(BinaryScaledAmount candidate) {
        return BinaryPrefix.unit.convertFrom(this.amount, this.binaryPrefix) == BinaryPrefix.unit.convertFrom(candidate.amount, candidate.binaryPrefix);
    }

    public BinaryScaledAmount multiply(double d) {
        return new BinaryScaledAmount(d * this.amount, this.binaryPrefix);
    }

    public BinaryScaledAmount divide(double d) {
        return this.multiply(1.0 / d);
    }

    public boolean equals(Object candidate) {
        if (!(candidate instanceof BinaryScaledAmount)) {
            return false;
        }
        return this.equals((BinaryScaledAmount)candidate);
    }

    public int hashCode() {
        return (int)BinaryPrefix.unit.convertFrom(this.amount, this.binaryPrefix);
    }
}

