/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StripedExecutor<Key> {
    private static final Logger logger = Logger.getLogger(StripedExecutor.class.getName());
    private final Map<Key, Deque<Runnable>> commands = new HashMap<Key, Deque<Runnable>>();
    private final ExecutorService executor;

    public StripedExecutor() {
        this(Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory(StripedExecutor.class.getSimpleName())));
    }

    public StripedExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Key key, Runnable command) {
        Map<Key, Deque<Runnable>> map = this.commands;
        synchronized (map) {
            if (null == this.commands.putIfAbsent(key, new ArrayDeque<Runnable>(List.of(command)))) {
                this.executor.execute(() -> this.runAll(key));
            } else {
                this.commands.get(key).add(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Key key) {
        while (true) {
            Runnable command;
            Map<Key, Deque<Runnable>> map = this.commands;
            synchronized (map) {
                Runnable runnable = command = this.commands.containsKey(key) ? this.commands.get(key).poll() : null;
                if (command == null) {
                    this.commands.remove(key);
                    break;
                }
            }
            try {
                command.run();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, e, () -> "Exception caught: " + Exceptions.toMessageString(e));
            }
        }
    }

    public void shutdownAndWait() {
        this.shutdownAndWait(Duration.ofSeconds(30L), Duration.ofSeconds(10L));
    }

    public void shutdownAndWait(Duration grace, Duration die) {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(grace.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.log(Level.INFO, "Interrupted waiting for executor to complete", e);
        }
        if (!this.executor.isTerminated()) {
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(die.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Interrupted waiting for executor to die", e);
            }
            if (!this.executor.isTerminated()) {
                throw new RuntimeException("Failed to shut down executor");
            }
        }
    }
}

