/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.compress;

public enum CompressionType {
    NONE(0),
    INCOMPRESSIBLE(5),
    LZ4(6),
    ZSTD(7);

    private final byte code;

    private CompressionType(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public boolean isCompressed() {
        return this != NONE && this != INCOMPRESSIBLE;
    }

    public static CompressionType valueOf(byte value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 5: {
                return INCOMPRESSIBLE;
            }
            case 6: {
                return LZ4;
            }
            case 7: {
                return ZSTD;
            }
        }
        throw new IllegalArgumentException("Unknown compression type ordinal " + value);
    }
}

