/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.LevelController;
import com.yahoo.log.LevelControllerRepo;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogTarget;
import com.yahoo.log.RejectFilter;
import com.yahoo.log.VespaFormatter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

class VespaLogHandler
extends StreamHandler {
    private static final Function<Level, Level> INFO_TO_FINE = level -> level == Level.INFO ? Level.FINE : level;
    private static final Map<String, Function<Level, Level>> loggersWithAlteredLogLevel = Map.ofEntries(Map.entry("com.yahoo.vespa.spifly.repackaged.spifly.BaseActivator", INFO_TO_FINE), Map.entry("org.eclipse.jetty.server.Server", INFO_TO_FINE), Map.entry("org.eclipse.jetty.server.handler.ContextHandler", INFO_TO_FINE), Map.entry("org.eclipse.jetty.server.AbstractConnector", INFO_TO_FINE), Map.entry("org.eclipse.jetty.util.HostPort", __ -> Level.FINE));
    private final LogTarget logTarget;
    private final String serviceName;
    private final String appPrefix;
    private final LevelControllerRepo repo;
    private final RejectFilter logRejectFilter;

    VespaLogHandler(LogTarget logTarget, LevelControllerRepo levelControllerRepo, String serviceName, String applicationPrefix) {
        this.logTarget = logTarget;
        this.serviceName = serviceName;
        this.appPrefix = applicationPrefix;
        this.repo = levelControllerRepo;
        this.logRejectFilter = RejectFilter.createDefaultRejectFilter();
        this.initialize();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        String loggerName = record.getLoggerName();
        Level level = VespaLogHandler.possiblyReduceLogLevel(loggerName, record.getLevel());
        LevelController ctrl = this.getLevelControl(loggerName);
        if (!ctrl.shouldLog(level)) {
            return;
        }
        if (this.logRejectFilter.shouldReject(record.getMessage())) {
            return;
        }
        try {
            this.setOutputStream(this.logTarget.open());
        }
        catch (RuntimeException e) {
            LogRecord r = new LogRecord(Level.SEVERE, "Unable to open file target");
            r.setThrown(e);
            this.emergencyLog(r);
            this.setOutputStream(System.err);
        }
        super.publish(record);
        this.flush();
        this.closeFileTarget();
    }

    private static Level possiblyReduceLogLevel(String loggerName, Level level) {
        if (loggerName == null) {
            return level;
        }
        Function<Level, Level> levelMapper = loggersWithAlteredLogLevel.get(loggerName);
        return levelMapper == null ? level : levelMapper.apply(level);
    }

    LevelController getLevelControl(String component) {
        return this.repo.getLevelController(component);
    }

    private void initialize() {
        try {
            this.setFormatter(new VespaFormatter(this.serviceName, this.appPrefix));
            this.setLevel(LogLevel.ALL);
            this.setEncoding("UTF-8");
            this.setOutputStream(this.logTarget.open());
        }
        catch (UnsupportedEncodingException uee) {
            LogRecord r = new LogRecord(Level.SEVERE, "Unable to set log encoding to UTF-8");
            r.setThrown(uee);
            this.emergencyLog(r);
        }
        catch (RuntimeException e) {
            LogRecord r = new LogRecord(Level.SEVERE, "Unable to open file target");
            r.setThrown(e);
            this.emergencyLog(r);
            this.setOutputStream(System.err);
        }
    }

    synchronized void closeFileTarget() {
        try {
            this.logTarget.close();
        }
        catch (RuntimeException e) {
            LogRecord r = new LogRecord(Level.WARNING, "Unable to close log");
            r.setThrown(e);
            this.emergencyLog(r);
        }
    }

    private void emergencyLog(LogRecord record) {
        record.setLoggerName(VespaLogHandler.class.getName());
        System.err.println(this.getFormatter().format(record));
    }

    public void cleanup() {
        this.repo.close();
    }
}

