/*
 * Decompiled with CFR 0.152.
 */
package com.yamanyar.mvn.plugin;

import com.yamanyar.mvn.plugin.RestrictLogger;
import com.yamanyar.mvn.plugin.RestrictionConfigurationFactory;
import com.yamanyar.mvn.plugin.inspectors.Inspector;
import com.yamanyar.mvn.plugin.utils.WildcardMatcher;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="restrict", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class RestrictMojo
extends AbstractMojo {
    @Parameter
    String[] restrictions;
    @Parameter
    boolean continueOnError;
    @Parameter
    boolean onlyInspectFolder;
    @Parameter
    boolean printDebugs = true;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(property="restrict.skip", defaultValue="false")
    private boolean skipThisMojo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skipThisMojo) {
            return;
        }
        if (!this.buildDirectory.exists()) {
            this.getLog().warn((CharSequence)("Directory " + this.buildDirectory + " does not exist, ignoring"));
            return;
        }
        File report = new File(this.buildDirectory, "restrict-maven-plugin.txt");
        RestrictLogger restrictLogger = new RestrictLogger(report, this.getLog());
        long x = System.currentTimeMillis();
        try {
            restrictLogger.info("restrict-maven-plugin started!");
            if (this.restrictions == null || this.restrictions.length == 0) {
                restrictLogger.warn("RestrictMojo is set as a plugin but it is not configured properly!");
                return;
            }
            Map<WildcardMatcher, Set<WildcardMatcher>> restrictionsMap = RestrictionConfigurationFactory.produceConfiguration(this.restrictions, (Log)restrictLogger, this.printDebugs);
            Inspector inspector = new Inspector((Log)restrictLogger, restrictionsMap, this.printDebugs);
            try {
                if (!this.onlyInspectFolder) {
                    Set artifacts = this.mavenProject.getDependencyArtifacts();
                    inspector.inspectArtifacts(artifacts);
                }
                inspector.inspectFolder(this.buildDirectory);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Can not inspect all the artifacts", e);
            }
            inspector.breakIfError(this.continueOnError);
        }
        finally {
            restrictLogger.info("restrict-maven-plugin completed in approx. " + Math.ceil((double)(System.currentTimeMillis() - x) / 1000.0) + " seconds.");
            restrictLogger.close();
        }
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }
}

