/*
 * Decompiled with CFR 0.152.
 */
package com.yamanyar.mvn.plugin.inspectors;

import com.yamanyar.mvn.plugin.RestrictedAccessException;
import com.yamanyar.mvn.plugin.utils.Extractor;
import com.yamanyar.mvn.plugin.utils.WildcardMatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

public class Inspector {
    private static final String errorMessage = "Restricted access from:(%s) %s to: %s due to rule [%d-%d]";
    private final Log log;
    private final Map<WildcardMatcher, Set<WildcardMatcher>> restrictionsMap;
    private int count = 0;
    private boolean printDebugs;

    public Inspector(Log log, Map<WildcardMatcher, Set<WildcardMatcher>> restrictionsMap, boolean printDebugs) {
        this.log = log;
        this.restrictionsMap = restrictionsMap;
        this.printDebugs = printDebugs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectJar(String path) throws IOException {
        JarFile jarFile = new JarFile(path);
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            InputStream entryStream = null;
            if (!entryName.endsWith(".class")) continue;
            try {
                entryStream = jarFile.getInputStream(jarEntry);
                this.inspectClass(entryStream, jarFile.getName());
            }
            finally {
                if (entryStream == null) continue;
                entryStream.close();
            }
        }
    }

    public void inspectWar(String path) throws IOException {
        this.inspectJar(path);
        File war = new File(path);
        JarFile warFile = new JarFile(path);
        File extractedDir = war.isFile() ? Extractor.extract(warFile) : war;
        Enumeration<JarEntry> jarEntries = warFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".jar")) continue;
            File subJarFile = new File(extractedDir.getCanonicalPath(), entryName);
            this.inspectJar(subJarFile.getAbsolutePath());
        }
    }

    public void inspectEar(String path) throws IOException {
        this.inspectJar(path);
        File war = new File(path);
        JarFile warFile = new JarFile(path);
        File extractedDir = war.isFile() ? Extractor.extract(warFile) : war;
        Enumeration<JarEntry> jarEntries = warFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            if (entryName.endsWith(".jar")) {
                File subJarFile = new File(extractedDir.getCanonicalPath(), entryName);
                this.inspectJar(subJarFile.getAbsolutePath());
                continue;
            }
            if (!entryName.endsWith(".war")) continue;
            File warJarFile = new File(extractedDir.getCanonicalPath(), entryName);
            this.inspectWar(warJarFile.getAbsolutePath());
        }
    }

    protected void inspectClass(InputStream entryStream, String path) throws IOException {
        ClassPool classPool = new ClassPool();
        CtClass currentClass = classPool.makeClass(entryStream);
        Set<WildcardMatcher> fromList = this.restrictionsMap.keySet();
        for (WildcardMatcher from : fromList) {
            Collection refClasses;
            if (!from.match(currentClass.getName()) || (refClasses = currentClass.getRefClasses()) == null) continue;
            for (Object targetReference : refClasses) {
                Set<WildcardMatcher> restrictedTargets = this.restrictionsMap.get(from);
                for (WildcardMatcher restrictedTarget : restrictedTargets) {
                    CtMethod[] declaredMethods;
                    if (!restrictedTarget.isMethod()) {
                        if (!restrictedTarget.match((String)targetReference)) continue;
                        ++this.count;
                        this.log.error((CharSequence)String.format(errorMessage, path, currentClass.getName(), targetReference, from.getRuleNo(), restrictedTarget.getRuleNo()));
                        continue;
                    }
                    if (!restrictedTarget.match((String)targetReference)) continue;
                    for (CtMethod declaredMethod : declaredMethods = currentClass.getDeclaredMethods()) {
                        MethodInfo minfo = declaredMethod.getMethodInfo();
                        minfo.getCodeAttribute();
                        CodeAttribute ca = minfo.getCodeAttribute();
                        if (null == ca) continue;
                        CodeIterator ci = ca.iterator();
                        while (ci.hasNext()) {
                            int index;
                            try {
                                index = ci.next();
                            }
                            catch (BadBytecode badBytecode) {
                                throw new IOException(badBytecode);
                            }
                            int op = ci.byteAt(index);
                            String desc = null;
                            if (index + 1 >= ci.getCodeLength() - 1) continue;
                            int theIndex = ci.u16bitAt(index + 1);
                            ConstPool constPool = ca.getConstPool();
                            switch (op) {
                                case 182: 
                                case 183: 
                                case 184: {
                                    if (constPool.getTag(theIndex) == 10) {
                                        desc = constPool.getMethodrefClassName(theIndex) + "." + constPool.getMethodrefName(theIndex) + "()";
                                        break;
                                    }
                                }
                                case 185: {
                                    desc = constPool.getInterfaceMethodrefClassName(theIndex) + "." + constPool.getInterfaceMethodrefName(theIndex) + "()";
                                }
                            }
                            if (desc == null) continue;
                            if (this.printDebugs) {
                                this.log.debug((CharSequence)("Checking " + restrictedTarget.toString() + " against " + desc));
                            }
                            if (!restrictedTarget.matchMethod(desc)) continue;
                            if (this.printDebugs) {
                                this.log.debug((CharSequence)("Method signature matched: " + restrictedTarget.toString() + " against " + desc));
                            }
                            ++this.count;
                            this.log.error((CharSequence)String.format(errorMessage, path, currentClass.getName(), desc, from.getRuleNo(), restrictedTarget.getRuleNo()));
                        }
                    }
                }
            }
        }
    }

    public void inspectArtifacts(Set<Artifact> artifacts) throws IOException {
        for (Artifact artifact : artifacts) {
            String path;
            if (this.printDebugs) {
                this.log.debug((CharSequence)("Inspecting " + artifact.toString()));
            }
            if ((path = artifact.getFile().getPath()).endsWith(".jar")) {
                this.inspectJar(path);
                continue;
            }
            if (path.endsWith(".war")) {
                this.inspectWar(path);
                continue;
            }
            if (path.endsWith(".ear")) {
                this.inspectEar(path);
                continue;
            }
            if (!path.endsWith(".class")) continue;
            File classFile = artifact.getFile();
            this.inspectClassFile(classFile);
        }
    }

    private void inspectClassFile(File classFile) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(classFile);
            this.inspectClass(is, classFile.getAbsolutePath());
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public void inspectFolder(File buildDirectory) throws IOException {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{".class"});
        IOFileFilter decoratedFilter = FileFilterUtils.makeSVNAware((IOFileFilter)filter);
        Collection files = FileUtils.listFiles((File)buildDirectory, (IOFileFilter)decoratedFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File file : files) {
            this.inspectClassFile(file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakIfError(boolean continueOnError) throws RestrictedAccessException {
        if (this.count > 0) {
            this.log.error((CharSequence)("Build is broken due to " + this.count + " restriction policies!"));
            if (!continueOnError) throw new RestrictedAccessException(this.count);
            this.log.error((CharSequence)"Build is not broken since continueOnError is set to true!");
            return;
        } else {
            this.log.info((CharSequence)"No restricted access is found");
        }
    }
}

