/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator;

import com.yammer.dropwizard.authenticator.TlsOption;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoclosingLdapContext
extends InitialLdapContext
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoclosingLdapContext.class);
    private StartTlsResponse tls = null;

    protected AutoclosingLdapContext() throws IOException, NamingException {
        this(new Hashtable(), TlsOption.NONE);
    }

    public AutoclosingLdapContext(Hashtable<?, ?> environment, TlsOption negotiateTls) throws IOException, NamingException {
        super(environment, null);
        switch (negotiateTls) {
            case ATTEMPT: {
                try {
                    this.tls = (StartTlsResponse)this.extendedOperation(new StartTlsRequest());
                    this.tls.negotiate();
                }
                catch (Exception err) {
                    LOGGER.info("Could not negotiate TLS", (Throwable)err);
                }
                break;
            }
            case STRICT: {
                this.tls = (StartTlsResponse)this.extendedOperation(new StartTlsRequest());
                this.tls.negotiate();
                break;
            }
        }
    }

    @Override
    public void close() throws NamingException {
        if (this.tls != null) {
            try {
                this.tls.close();
            }
            catch (Exception err) {
                LOGGER.error("Could not close TLS", (Throwable)err);
            }
        }
        super.close();
    }
}

