/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.yammer.dropwizard.authenticator.AutoclosingLdapContext;
import com.yammer.dropwizard.authenticator.LdapConfiguration;
import com.yammer.dropwizard.authenticator.User;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.basic.BasicCredentials;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticator.class);
    protected final LdapConfiguration configuration;

    public LdapAuthenticator(LdapConfiguration configuration) {
        this.configuration = (LdapConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    private static String sanitizeEntity(String name) {
        return name.replaceAll("[^A-Za-z0-9-_.]", "");
    }

    public boolean canAuthenticate() {
        try {
            new AutoclosingLdapContext(this.contextConfiguration(), this.configuration.getNegotiateTls()).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filterByGroup(AutoclosingLdapContext context, String sanitizedUsername) throws NamingException {
        Set<String> restrictedToGroups = this.configuration.getRestrictToGroups();
        if (restrictedToGroups.isEmpty()) {
            return true;
        }
        StringBuilder groupFilter = new StringBuilder();
        for (String group : restrictedToGroups) {
            String sanitizedGroup = LdapAuthenticator.sanitizeEntity(group);
            groupFilter.append(String.format("(%s=%s)", this.configuration.getGroupNameAttribute(), sanitizedGroup));
        }
        String filter = String.format("(&(%s=%s)(|%s))", this.configuration.getGroupMembershipAttribute(), this.userNameBaseOnGroupClass(sanitizedUsername), groupFilter.toString());
        try (NamingEnumeration<SearchResult> result = context.search(this.configuration.getGroupFilter(), filter, new SearchControls());){
            boolean bl = result.hasMore();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getGroupMembershipsIntersectingWithRestrictedGroups(AutoclosingLdapContext context, String userName) throws NamingException {
        userName = this.userNameBaseOnGroupClass(userName);
        String filter = String.format("(&(%s=%s)(objectClass=%s))", this.configuration.getGroupMembershipAttribute(), userName, this.configuration.getGroupClassName());
        ImmutableSet.Builder overlappingGroups = ImmutableSet.builder();
        try (NamingEnumeration<SearchResult> result = context.search(this.configuration.getGroupFilter(), filter, new SearchControls());){
            while (result.hasMore()) {
                SearchResult next = result.next();
                if (next.getAttributes() == null || next.getAttributes().get(this.configuration.getGroupNameAttribute()) == null) continue;
                String group = (String)next.getAttributes().get(this.configuration.getGroupNameAttribute()).get(0);
                if (!this.configuration.getRestrictToGroups().isEmpty() && !this.configuration.getRestrictToGroups().contains(group)) continue;
                overlappingGroups.add((Object)group);
            }
            ImmutableSet immutableSet = overlappingGroups.build();
            return immutableSet;
        }
    }

    private String userNameBaseOnGroupClass(String userName) {
        return LdapAuthenticator.groupRequiresDn(this.configuration.getGroupClassName(), this.configuration.getGroupMembershipAttribute()) ? this.toUserDN(userName) : userName;
    }

    private static boolean groupRequiresDn(String className, String membershipAttr) {
        return "groupOfNames".equalsIgnoreCase(className) && "member".equalsIgnoreCase(membershipAttr) || "groupOfUniqueNames".equalsIgnoreCase(className) && "uniqueMember".equalsIgnoreCase(membershipAttr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate(BasicCredentials credentials) throws AuthenticationException {
        String sanitizedUsername = LdapAuthenticator.sanitizeEntity(credentials.getUsername());
        try (AutoclosingLdapContext context = this.buildContext(sanitizedUsername, credentials.getPassword());){
            boolean bl = this.filterByGroup(context, sanitizedUsername);
            return bl;
        }
        catch (javax.naming.AuthenticationException ae) {
            LOG.debug("{} failed to authenticate. {}", (Object)sanitizedUsername, (Object)ae);
            return false;
        }
        catch (IOException | NamingException err) {
            throw new AuthenticationException(String.format("LDAP Authentication failure (username: %s)", sanitizedUsername), (Throwable)err);
        }
    }

    private AutoclosingLdapContext buildContext(String sanitizedUsername, String password) throws IOException, NamingException {
        String userDN = this.toUserDN(sanitizedUsername);
        Hashtable<String, String> env = this.contextConfiguration();
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", password);
        return new AutoclosingLdapContext(env, this.configuration.getNegotiateTls());
    }

    private String toUserDN(String username) {
        return String.format("%s=%s,%s", this.configuration.getUserNameAttribute(), username, this.configuration.getUserFilter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<User> authenticateAndReturnPermittedGroups(BasicCredentials credentials) throws AuthenticationException {
        String sanitizedUsername = LdapAuthenticator.sanitizeEntity(credentials.getUsername());
        try (AutoclosingLdapContext context = this.buildContext(sanitizedUsername, credentials.getPassword());){
            Set<String> groupMemberships = this.getGroupMembershipsIntersectingWithRestrictedGroups(context, sanitizedUsername);
            if (groupMemberships.isEmpty()) return Optional.empty();
            Optional<User> optional = Optional.of(new User(sanitizedUsername, groupMemberships));
            return optional;
        }
        catch (javax.naming.AuthenticationException ae) {
            LOG.debug("{} failed to authenticate. {}", (Object)sanitizedUsername, (Object)ae);
            return Optional.empty();
        }
        catch (IOException | NamingException err) {
            throw new AuthenticationException(String.format("LDAP Authentication failure (username: %s)", sanitizedUsername), (Throwable)err);
        }
    }

    private Hashtable<String, String> contextConfiguration() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.configuration.getUri().toString());
        env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.configuration.getConnectTimeout().toMilliseconds()));
        env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.configuration.getReadTimeout().toMilliseconds()));
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        return env;
    }
}

