/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator;

import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.Sets;
import com.yammer.dropwizard.authenticator.TlsOption;
import io.dropwizard.util.Duration;
import java.net.URI;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class LdapConfiguration {
    @NotNull
    @Valid
    private URI uri = URI.create("ldaps://www.example.com:636");
    @NotNull
    @Valid
    private CacheBuilderSpec cachePolicy = CacheBuilderSpec.disableCaching();
    @NotNull
    @NotEmpty
    private String userFilter = "ou=people,dc=example,dc=com";
    @NotNull
    @NotEmpty
    private String groupFilter = "ou=groups,dc=example,dc=com";
    @NotNull
    @NotEmpty
    private String userNameAttribute = "cn";
    @NotNull
    @NotEmpty
    private String groupNameAttribute = "cn";
    @NotNull
    @NotEmpty
    private String groupMembershipAttribute = "memberUid";
    @NotNull
    @NotEmpty
    private String groupClassName = "posixGroup";
    @NotNull
    @Valid
    private Duration connectTimeout = Duration.milliseconds((long)500L);
    @NotNull
    @Valid
    private Duration readTimeout = Duration.milliseconds((long)500L);
    @NotNull
    @Valid
    private Set<String> restrictToGroups = Sets.newHashSet();
    @NotNull
    @Valid
    private TlsOption negotiateTls = TlsOption.NONE;

    public URI getUri() {
        return this.uri;
    }

    public LdapConfiguration setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public CacheBuilderSpec getCachePolicy() {
        return this.cachePolicy;
    }

    public LdapConfiguration setCachePolicy(CacheBuilderSpec cachePolicy) {
        this.cachePolicy = cachePolicy;
        return this;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public LdapConfiguration setUserFilter(String userFilter) {
        this.userFilter = userFilter;
        return this;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public LdapConfiguration setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
        return this;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public LdapConfiguration setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
        return this;
    }

    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    public LdapConfiguration setGroupNameAttribute(String groupNameAttribute) {
        this.groupNameAttribute = groupNameAttribute;
        return this;
    }

    public String getGroupMembershipAttribute() {
        return this.groupMembershipAttribute;
    }

    public LdapConfiguration setGroupMembershipAttribute(String groupMembershipAttribute) {
        this.groupMembershipAttribute = groupMembershipAttribute;
        return this;
    }

    public String getGroupClassName() {
        return this.groupClassName;
    }

    public LdapConfiguration setGroupClassName(String groupClassName) {
        this.groupClassName = groupClassName;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public LdapConfiguration setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public LdapConfiguration setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Set<String> getRestrictToGroups() {
        return this.restrictToGroups;
    }

    public LdapConfiguration addRestrictedGroup(String group) {
        this.restrictToGroups.add(group);
        return this;
    }

    public TlsOption getNegotiateTls() {
        return this.negotiateTls;
    }

    public void setNegotiateTls(TlsOption negotiateTls) {
        this.negotiateTls = negotiateTls;
    }
}

