/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.guice;

import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class ExceptionMeteredInterceptor
implements MethodInterceptor {
    private final Meter meter;
    private final Class<? extends Throwable> klass;

    static MethodInterceptor forMethod(MetricsRegistry metricsRegistry, Class<?> klass, Method method) {
        ExceptionMetered annotation = method.getAnnotation(ExceptionMetered.class);
        if (annotation != null) {
            String group = MetricName.chooseGroup((String)annotation.group(), klass);
            String type = MetricName.chooseType((String)annotation.type(), klass);
            String name = ExceptionMeteredInterceptor.determineName(annotation, method);
            MetricName metricName = new MetricName(group, type, name);
            Meter meter = metricsRegistry.newMeter(metricName, annotation.eventType(), annotation.rateUnit());
            return new ExceptionMeteredInterceptor(meter, annotation.cause());
        }
        return null;
    }

    private static String determineName(ExceptionMetered annotation, Method method) {
        if (annotation.name().isEmpty()) {
            return method.getName() + "Exceptions";
        }
        return annotation.name();
    }

    private ExceptionMeteredInterceptor(Meter meter, Class<? extends Throwable> klass) {
        this.meter = meter;
        this.klass = klass;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            if (this.klass.isAssignableFrom(t.getClass())) {
                this.meter.mark();
            }
            throw t;
        }
    }
}

