/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.guice;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.yammer.metrics.annotation.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.guice.GaugeInjectionListener;
import java.lang.reflect.Method;

class GaugeListener
implements TypeListener {
    private final MetricsRegistry metricsRegistry;

    GaugeListener(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        for (Method method : literal.getRawType().getMethods()) {
            Gauge annotation = method.getAnnotation(Gauge.class);
            if (annotation == null) continue;
            if (method.getParameterTypes().length == 0) {
                String group = MetricName.chooseGroup((String)annotation.group(), (Class)literal.getRawType());
                String type = MetricName.chooseType((String)annotation.type(), (Class)literal.getRawType());
                String name = MetricName.chooseName((String)annotation.name(), (Method)method);
                MetricName metricName = new MetricName(group, type, name);
                encounter.register(new GaugeInjectionListener(this.metricsRegistry, metricName, method));
                continue;
            }
            encounter.addError("Method %s is annotated with @Gauge but requires parameters.", new Object[]{method});
        }
    }
}

