/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jdbi;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.jdbi.strategies.SmartNameStrategy;
import com.yammer.metrics.jdbi.strategies.StatementNameStrategy;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TimingCollector;

public class InstrumentedTimingCollector
implements TimingCollector {
    private final MetricsRegistry registry;
    private final StatementNameStrategy statementNameStrategy;
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;

    public InstrumentedTimingCollector() {
        this(Metrics.defaultRegistry());
    }

    public InstrumentedTimingCollector(MetricsRegistry registry) {
        this(registry, new SmartNameStrategy(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public InstrumentedTimingCollector(MetricsRegistry registry, StatementNameStrategy statementNameStrategy) {
        this(registry, statementNameStrategy, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public InstrumentedTimingCollector(MetricsRegistry registry, StatementNameStrategy statementNameStrategy, TimeUnit durationUnit, TimeUnit rateUnit) {
        this.registry = registry;
        this.statementNameStrategy = statementNameStrategy;
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
    }

    public void collect(long elapsedTime, StatementContext ctx) {
        Timer timer = this.getTimer(ctx);
        timer.update(elapsedTime, TimeUnit.NANOSECONDS);
    }

    private Timer getTimer(StatementContext ctx) {
        return this.registry.newTimer(this.statementNameStrategy.getStatementName(ctx), this.durationUnit, this.rateUnit);
    }
}

