/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jetty;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;

public class InstrumentedBlockingChannelConnector
extends BlockingChannelConnector {
    private final Timer duration;
    private final Meter accepts;
    private final Meter connects;
    private final Meter disconnects;
    private final Counter connections;

    public InstrumentedBlockingChannelConnector(int port) {
        this(Metrics.defaultRegistry(), port);
    }

    public InstrumentedBlockingChannelConnector(MetricsRegistry registry, int port) {
        this.setPort(port);
        this.duration = registry.newTimer(BlockingChannelConnector.class, "connection-duration", Integer.toString(port), TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        this.accepts = registry.newMeter(BlockingChannelConnector.class, "accepts", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.connects = registry.newMeter(BlockingChannelConnector.class, "connects", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.disconnects = registry.newMeter(BlockingChannelConnector.class, "disconnects", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.connections = registry.newCounter(BlockingChannelConnector.class, "active-connections", Integer.toString(port));
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        super.accept(acceptorID);
        this.accepts.mark();
    }

    protected void connectionOpened(Connection connection) {
        this.connections.inc();
        super.connectionOpened(connection);
        this.connects.mark();
    }

    protected void connectionClosed(Connection connection) {
        super.connectionClosed(connection);
        this.disconnects.mark();
        long duration = System.currentTimeMillis() - connection.getTimeStamp();
        this.duration.update(duration, TimeUnit.MILLISECONDS);
        this.connections.dec();
    }
}

