/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jetty;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.util.RatioGauge;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class InstrumentedHandler
extends HandlerWrapper {
    private static final String PATCH = "PATCH";
    private final Timer dispatches;
    private final Meter requests;
    private final Meter resumes;
    private final Meter suspends;
    private final Meter expires;
    private final Counter activeRequests;
    private final Counter activeSuspendedRequests;
    private final Counter activeDispatches;
    private final Meter[] responses;
    private final Timer getRequests;
    private final Timer postRequests;
    private final Timer headRequests;
    private final Timer putRequests;
    private final Timer deleteRequests;
    private final Timer optionsRequests;
    private final Timer traceRequests;
    private final Timer connectRequests;
    private final Timer patchRequests;
    private final Timer otherRequests;
    private final ContinuationListener listener;

    public InstrumentedHandler(Handler underlying) {
        this.dispatches = Metrics.newTimer(underlying.getClass(), (String)"dispatches", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.requests = Metrics.newMeter(underlying.getClass(), (String)"requests", (String)"requests", (TimeUnit)TimeUnit.SECONDS);
        this.resumes = Metrics.newMeter(underlying.getClass(), (String)"resumes", (String)"requests", (TimeUnit)TimeUnit.SECONDS);
        this.suspends = Metrics.newMeter(underlying.getClass(), (String)"suspends", (String)"requests", (TimeUnit)TimeUnit.SECONDS);
        this.expires = Metrics.newMeter(underlying.getClass(), (String)"expires", (String)"requests", (TimeUnit)TimeUnit.SECONDS);
        this.activeRequests = Metrics.newCounter(underlying.getClass(), (String)"active-requests");
        this.activeSuspendedRequests = Metrics.newCounter(underlying.getClass(), (String)"active-suspended-requests");
        this.activeDispatches = Metrics.newCounter(underlying.getClass(), (String)"active-dispatches");
        this.responses = new Meter[]{Metrics.newMeter(underlying.getClass(), (String)"1xx-responses", (String)"responses", (TimeUnit)TimeUnit.SECONDS), Metrics.newMeter(underlying.getClass(), (String)"2xx-responses", (String)"responses", (TimeUnit)TimeUnit.SECONDS), Metrics.newMeter(underlying.getClass(), (String)"3xx-responses", (String)"responses", (TimeUnit)TimeUnit.SECONDS), Metrics.newMeter(underlying.getClass(), (String)"4xx-responses", (String)"responses", (TimeUnit)TimeUnit.SECONDS), Metrics.newMeter(underlying.getClass(), (String)"5xx-responses", (String)"responses", (TimeUnit)TimeUnit.SECONDS)};
        Metrics.newGauge(underlying.getClass(), (String)"percent-4xx-1m", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return InstrumentedHandler.this.responses[3].oneMinuteRate();
            }

            protected double getDenominator() {
                return InstrumentedHandler.this.requests.oneMinuteRate();
            }
        });
        Metrics.newGauge(underlying.getClass(), (String)"percent-4xx-5m", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return InstrumentedHandler.this.responses[3].fiveMinuteRate();
            }

            protected double getDenominator() {
                return InstrumentedHandler.this.requests.fiveMinuteRate();
            }
        });
        Metrics.newGauge(underlying.getClass(), (String)"percent-4xx-15m", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return InstrumentedHandler.this.responses[3].fifteenMinuteRate();
            }

            protected double getDenominator() {
                return InstrumentedHandler.this.requests.fifteenMinuteRate();
            }
        });
        Metrics.newGauge(underlying.getClass(), (String)"percent-5xx-1m", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return InstrumentedHandler.this.responses[4].oneMinuteRate();
            }

            protected double getDenominator() {
                return InstrumentedHandler.this.requests.oneMinuteRate();
            }
        });
        Metrics.newGauge(underlying.getClass(), (String)"percent-5xx-5m", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return InstrumentedHandler.this.responses[4].fiveMinuteRate();
            }

            protected double getDenominator() {
                return InstrumentedHandler.this.requests.fiveMinuteRate();
            }
        });
        Metrics.newGauge(underlying.getClass(), (String)"percent-5xx-15m", (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return InstrumentedHandler.this.responses[4].fifteenMinuteRate();
            }

            protected double getDenominator() {
                return InstrumentedHandler.this.requests.fifteenMinuteRate();
            }
        });
        this.listener = new ContinuationListener(){

            public void onComplete(Continuation continuation) {
                InstrumentedHandler.this.expires.mark();
            }

            public void onTimeout(Continuation continuation) {
                Request request = ((AsyncContinuation)continuation).getBaseRequest();
                InstrumentedHandler.this.updateResponses(request);
                if (!continuation.isResumed()) {
                    InstrumentedHandler.this.activeSuspendedRequests.dec();
                }
            }
        };
        this.getRequests = Metrics.newTimer(underlying.getClass(), (String)"get-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.postRequests = Metrics.newTimer(underlying.getClass(), (String)"post-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.headRequests = Metrics.newTimer(underlying.getClass(), (String)"head-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.putRequests = Metrics.newTimer(underlying.getClass(), (String)"put-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.deleteRequests = Metrics.newTimer(underlying.getClass(), (String)"delete-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.optionsRequests = Metrics.newTimer(underlying.getClass(), (String)"options-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.traceRequests = Metrics.newTimer(underlying.getClass(), (String)"trace-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.connectRequests = Metrics.newTimer(underlying.getClass(), (String)"connect-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.patchRequests = Metrics.newTimer(underlying.getClass(), (String)"patch-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.otherRequests = Metrics.newTimer(underlying.getClass(), (String)"other-requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.setHandler(underlying);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        boolean isMilliseconds;
        long start;
        this.activeDispatches.inc();
        AsyncContinuation continuation = request.getAsyncContinuation();
        if (continuation.isInitial()) {
            this.activeRequests.inc();
            start = request.getTimeStamp();
            isMilliseconds = true;
        } else {
            this.activeSuspendedRequests.dec();
            if (continuation.isResumed()) {
                this.resumes.mark();
            }
            isMilliseconds = false;
            start = System.nanoTime();
        }
        try {
            super.handle(target, request, httpRequest, httpResponse);
        }
        finally {
            if (isMilliseconds) {
                long duration = System.currentTimeMillis() - start;
                this.dispatches.update(duration, TimeUnit.MILLISECONDS);
                this.requestTimer(request.getMethod()).update(duration, TimeUnit.MILLISECONDS);
            } else {
                long duration = System.nanoTime() - start;
                this.dispatches.update(duration, TimeUnit.NANOSECONDS);
                this.requestTimer(request.getMethod()).update(duration, TimeUnit.NANOSECONDS);
            }
            this.activeDispatches.dec();
            if (continuation.isSuspended()) {
                if (continuation.isInitial()) {
                    continuation.addContinuationListener(this.listener);
                }
                this.suspends.mark();
                this.activeSuspendedRequests.inc();
            } else if (continuation.isInitial()) {
                this.updateResponses(request);
            }
        }
    }

    private Timer requestTimer(String method) {
        if ("GET".equalsIgnoreCase(method)) {
            return this.getRequests;
        }
        if ("POST".equalsIgnoreCase(method)) {
            return this.postRequests;
        }
        if ("PUT".equalsIgnoreCase(method)) {
            return this.putRequests;
        }
        if ("HEAD".equalsIgnoreCase(method)) {
            return this.headRequests;
        }
        if ("DELETE".equalsIgnoreCase(method)) {
            return this.deleteRequests;
        }
        if ("OPTIONS".equalsIgnoreCase(method)) {
            return this.optionsRequests;
        }
        if ("TRACE".equalsIgnoreCase(method)) {
            return this.traceRequests;
        }
        if ("CONNECT".equalsIgnoreCase(method)) {
            return this.connectRequests;
        }
        if (PATCH.equalsIgnoreCase(method)) {
            return this.patchRequests;
        }
        return this.otherRequests;
    }

    private void updateResponses(Request request) {
        int response = request.getResponse().getStatus() / 100;
        if (response >= 1 && response <= 5) {
            this.responses[response - 1].mark();
        }
        this.activeRequests.dec();
        this.requests.mark();
    }
}

