/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.TimeUnit;

public class InstrumentedAppender
extends AppenderBase<ILoggingEvent> {
    private final Meter all;
    private final Meter trace;
    private final Meter debug;
    private final Meter info;
    private final Meter warn;
    private final Meter error;

    public InstrumentedAppender() {
        this(Metrics.defaultRegistry());
    }

    public InstrumentedAppender(MetricsRegistry registry) {
        this.all = registry.newMeter(Appender.class, "all", "statements", TimeUnit.SECONDS);
        this.trace = registry.newMeter(Appender.class, "trace", "statements", TimeUnit.SECONDS);
        this.debug = registry.newMeter(Appender.class, "debug", "statements", TimeUnit.SECONDS);
        this.info = registry.newMeter(Appender.class, "info", "statements", TimeUnit.SECONDS);
        this.warn = registry.newMeter(Appender.class, "warn", "statements", TimeUnit.SECONDS);
        this.error = registry.newMeter(Appender.class, "error", "statements", TimeUnit.SECONDS);
    }

    protected void append(ILoggingEvent event) {
        this.all.mark();
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark();
                break;
            }
            case 10000: {
                this.debug.mark();
                break;
            }
            case 20000: {
                this.info.mark();
                break;
            }
            case 30000: {
                this.warn.mark();
                break;
            }
            case 40000: {
                this.error.mark();
            }
        }
    }
}

