/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.tenacity.testing;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.metric.consumer.CumulativeCollapserEventCounterStream;
import com.netflix.hystrix.metric.consumer.CumulativeCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.CumulativeThreadPoolEventCounterStream;
import com.netflix.hystrix.metric.consumer.HealthCountsStream;
import com.netflix.hystrix.metric.consumer.RollingCollapserBatchSizeDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCollapserEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandLatencyDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCommandMaxConcurrencyStream;
import com.netflix.hystrix.metric.consumer.RollingCommandUserLatencyDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingThreadPoolEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingThreadPoolMaxConcurrencyStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.AbstractConfiguration;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TenacityTestRule
implements TestRule {
    private void setup() {
        this.resetStreams();
        Hystrix.reset();
        AbstractConfiguration configuration = ConfigurationManager.getConfigInstance();
        configuration.setProperty("hystrix.command.default.metrics.healthSnapshot.intervalInMilliseconds", (Object)"100");
    }

    public void teardown() {
        Hystrix.reset((long)1L, (TimeUnit)TimeUnit.SECONDS);
        ConfigurationManager.getConfigInstance().clear();
    }

    private void resetStreams() {
        CumulativeCommandEventCounterStream.reset();
        RollingCommandEventCounterStream.reset();
        CumulativeCollapserEventCounterStream.reset();
        RollingCollapserEventCounterStream.reset();
        CumulativeThreadPoolEventCounterStream.reset();
        RollingThreadPoolEventCounterStream.reset();
        HealthCountsStream.reset();
        RollingThreadPoolMaxConcurrencyStream.reset();
        RollingCommandMaxConcurrencyStream.reset();
        RollingCommandLatencyDistributionStream.reset();
        RollingCommandUserLatencyDistributionStream.reset();
        RollingCollapserBatchSizeDistributionStream.reset();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    TenacityTestRule.this.setup();
                    base.evaluate();
                }
                finally {
                    TenacityTestRule.this.teardown();
                }
            }
        };
    }
}

