/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.dwarf;

import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.ndk.dwarf.DwarfException;
import com.yandex.android.appmetrica.ndk.dwarf.FileContext;
import com.yandex.android.appmetrica.ndk.dwarf.ReferenceBytesConverter;
import com.yandex.android.appmetrica.ndk.dwarf.info.CompilationUnitContext;
import com.yandex.android.appmetrica.ndk.dwarf.info.DebugInfoParserKt;
import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineData;
import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineStateMachineKt;
import com.yandex.android.appmetrica.ndk.elf.DebugElfSectionHeaders;
import com.yandex.android.appmetrica.ndk.elf.ElfHandler;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeader;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"parseDebugLineData", "Lcom/yandex/android/appmetrica/ndk/dwarf/line/DebugLineData;", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "context", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/CompilationUnitContext;", "debugLineSectionHeader", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSectionHeader;", "parseDwarf", "", "handler", "Lcom/yandex/android/appmetrica/ndk/elf/ElfHandler;", "byteOrder", "Ljava/nio/ByteOrder;", "debugHeaders", "Lcom/yandex/android/appmetrica/ndk/elf/DebugElfSectionHeaders;", "appmetrica-build-plugin"})
public final class DwarfParserKt {
    /*
     * WARNING - void declaration
     */
    public static final void parseDwarf(@NotNull ByteReader reader, @NotNull ElfHandler handler, @NotNull ByteOrder byteOrder, @NotNull DebugElfSectionHeaders debugHeaders) throws IOException, DwarfException {
        Collection<Pair<void, DebugLineData>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        Intrinsics.checkParameterIsNotNull(byteOrder, "byteOrder");
        Intrinsics.checkParameterIsNotNull(debugHeaders, "debugHeaders");
        Log.INSTANCE.debug("Processing debug headers : " + debugHeaders.getHeaderNames());
        FileContext fileContext = new FileContext(debugHeaders, new ReferenceBytesConverter(byteOrder), null, 4, null);
        Log.INSTANCE.debug("Reading compilation unit contexts");
        Iterable iterable = DebugInfoParserKt.parseDebugInfo(reader, fileContext);
        ElfHandler elfHandler = handler;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cuContext;
            CompilationUnitContext compilationUnitContext = (CompilationUnitContext)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Log.INSTANCE.debug("Reading debug line data for compilation unit " + cuContext.getName());
            Pair<void, DebugLineData> pair = TuplesKt.to(cuContext, DwarfParserKt.parseDebugLineData(reader, (CompilationUnitContext)cuContext, debugHeaders.getDebugLine()));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        elfHandler.processDebugInfoCompilationUnit(MapsKt.toMap((Iterable)collection));
    }

    @NotNull
    public static final DebugLineData parseDebugLineData(@NotNull ByteReader reader, @NotNull CompilationUnitContext context, @NotNull ElfSectionHeader debugLineSectionHeader) throws IOException {
        DebugLineData debugLineData;
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(debugLineSectionHeader, "debugLineSectionHeader");
        Long debugLineOffset = context.getDebugLineOffset();
        if (debugLineOffset != null) {
            DebugLineData debugLineData2;
            try {
                reader.seek(debugLineSectionHeader.getOffset() + debugLineOffset);
                debugLineData2 = DebugLineStateMachineKt.parseDebugLinesFromCurrentOffset(reader, context.getHeader().getAddressSize());
            }
            catch (DwarfException e) {
                Log.INSTANCE.debug("Could not parse debug line data : " + e);
                debugLineData2 = new DebugLineData(null, null, 3, null);
            }
            debugLineData = debugLineData2;
        } else {
            Log.INSTANCE.debug("Could not parse debug line data : debug line offset is null");
            debugLineData = new DebugLineData(null, null, 3, null);
        }
        return debugLineData;
    }
}

