/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.dwarf.info.attribute.reader;

import com.yandex.android.appmetrica.ndk.dwarf.ReferenceBytesConverter;
import com.yandex.android.appmetrica.ndk.dwarf.abbrev.DebugAbbrevAttribute;
import com.yandex.android.appmetrica.ndk.dwarf.info.CompilationUnitHeader;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.processor.AttributeProcessor;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.reader.AttributesReader;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.reader.DebugAttributesReader$WhenMappings;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.reader.DebugAttributesReaderKt;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001b\u0010\u0012\u001a\u00028\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/yandex/android/appmetrica/ndk/dwarf/info/attribute/reader/DebugAttributesReader;", "T", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/attribute/reader/AttributesReader;", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "cuHeader", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/CompilationUnitHeader;", "referenceBytesConverter", "Lcom/yandex/android/appmetrica/ndk/dwarf/ReferenceBytesConverter;", "attributeProcessor", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/attribute/processor/AttributeProcessor;", "debugStrOffset", "", "(Lcom/yandex/android/appmetrica/ndk/io/ByteReader;Lcom/yandex/android/appmetrica/ndk/dwarf/info/CompilationUnitHeader;Lcom/yandex/android/appmetrica/ndk/dwarf/ReferenceBytesConverter;Lcom/yandex/android/appmetrica/ndk/dwarf/info/attribute/processor/AttributeProcessor;J)V", "processDebugInfoEntryAttribute", "", "attribute", "Lcom/yandex/android/appmetrica/ndk/dwarf/abbrev/DebugAbbrevAttribute;", "readAttributes", "attributes", "", "(Ljava/util/List;)Ljava/lang/Object;", "appmetrica-build-plugin"})
public final class DebugAttributesReader<T>
implements AttributesReader<T> {
    private final ByteReader reader;
    private final CompilationUnitHeader cuHeader;
    private final ReferenceBytesConverter referenceBytesConverter;
    private final AttributeProcessor<T> attributeProcessor;
    private final long debugStrOffset;

    @Override
    public T readAttributes(@NotNull List<DebugAbbrevAttribute> attributes) throws IOException {
        Intrinsics.checkParameterIsNotNull(attributes, "attributes");
        Iterable $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugAbbrevAttribute it = (DebugAbbrevAttribute)element$iv;
            boolean bl = false;
            this.processDebugInfoEntryAttribute(it);
        }
        return this.attributeProcessor.finishProcessingAttributes();
    }

    private final void processDebugInfoEntryAttribute(DebugAbbrevAttribute attribute) throws IOException {
        switch (DebugAttributesReader$WhenMappings.$EnumSwitchMapping$0[attribute.getForm().ordinal()]) {
            case 1: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(this.cuHeader.getAddressSize()));
                break;
            }
            case 2: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytesWithBlockSize());
                break;
            }
            case 3: {
                byte[] bytes = this.reader.readBytesWithBlockSize(1);
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), bytes);
                break;
            }
            case 4: {
                byte[] bytes = this.reader.readBytesWithBlockSize(2);
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), bytes);
                break;
            }
            case 5: {
                byte[] bytes = this.reader.readBytesWithBlockSize(4);
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), bytes);
                break;
            }
            case 6: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(1));
                break;
            }
            case 7: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(2));
                break;
            }
            case 8: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(4));
                break;
            }
            case 9: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(8));
                break;
            }
            case 10: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readSLEB128());
                break;
            }
            case 11: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readULEB128());
                break;
            }
            case 12: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readNullTerminatedString(Charsets.UTF_8));
                break;
            }
            case 13: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(1));
                break;
            }
            case 14: {
                this.attributeProcessor.processAttribute(attribute.getName(), 1L);
                break;
            }
            case 15: {
                String value = DebugAttributesReaderKt.access$readStringFromTable(this.reader, this.cuHeader.getWordSize(), this.debugStrOffset);
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 16: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(1)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 17: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(2)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 18: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(4)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 19: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(8)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 20: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(DebugAttributesReaderKt.access$getBytesCountForRefAddr(this.cuHeader)));
                break;
            }
            case 21: {
                this.attributeProcessor.processAttribute(attribute.getName(), (long)this.reader.readULEB128() + this.cuHeader.getOffset());
                break;
            }
            case 22: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(8));
                break;
            }
            case 23: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytesWithBlockSize());
                break;
            }
            case 24: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(this.cuHeader.getWordSize()));
                break;
            }
            default: {
                this.attributeProcessor.processAttribute(attribute.getName(), 0L);
            }
        }
    }

    public DebugAttributesReader(@NotNull ByteReader reader, @NotNull CompilationUnitHeader cuHeader, @NotNull ReferenceBytesConverter referenceBytesConverter, @NotNull AttributeProcessor<T> attributeProcessor, long debugStrOffset) {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(cuHeader, "cuHeader");
        Intrinsics.checkParameterIsNotNull(referenceBytesConverter, "referenceBytesConverter");
        Intrinsics.checkParameterIsNotNull(attributeProcessor, "attributeProcessor");
        this.reader = reader;
        this.cuHeader = cuHeader;
        this.referenceBytesConverter = referenceBytesConverter;
        this.attributeProcessor = attributeProcessor;
        this.debugStrOffset = debugStrOffset;
    }
}

