/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.dwarf.line.opcode;

import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineContext;
import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineRegisters;
import com.yandex.android.appmetrica.ndk.dwarf.line.opcode.OpcodeProcessorKt;
import com.yandex.android.appmetrica.ndk.dwarf.line.opcode.StandardOpcode;
import com.yandex.android.appmetrica.ndk.dwarf.line.opcode.StandardOpcodeKt$WhenMappings;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"CONST_OPCODE", "", "NUMBER_OF_STANDARD_OPCODE", "processStandardOpcode", "", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "context", "Lcom/yandex/android/appmetrica/ndk/dwarf/line/DebugLineContext;", "opcode", "appmetrica-build-plugin"})
public final class StandardOpcodeKt {
    private static final int CONST_OPCODE = 255;
    private static final int NUMBER_OF_STANDARD_OPCODE = 12;

    public static final boolean processStandardOpcode(@NotNull ByteReader reader, @NotNull DebugLineContext context, int opcode) throws IOException {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (opcode > 12) {
            reader.readBytes(context.getHeader().getStandardOpcodeLengths()[opcode]);
            return false;
        }
        StandardOpcode standardOpcode = StandardOpcode.Companion.fromValue(opcode);
        switch (StandardOpcodeKt$WhenMappings.$EnumSwitchMapping$0[standardOpcode.ordinal()]) {
            case 1: {
                context.getRegisters().setDiscriminator(0L);
                context.getRegisters().setBasicBlock(false);
                context.getRegisters().setPrologueEnd(false);
                context.getRegisters().setEpilogueBegin(false);
                break;
            }
            case 2: {
                OpcodeProcessorKt.incrementAddressAndOpIndex(context, reader.readULEB128());
                break;
            }
            case 3: {
                DebugLineRegisters debugLineRegisters = context.getRegisters();
                debugLineRegisters.setLine(debugLineRegisters.getLine() + (long)reader.readSLEB128());
                break;
            }
            case 4: {
                context.getRegisters().setFile(reader.readULEB128());
                break;
            }
            case 5: {
                context.getRegisters().setColumn(reader.readULEB128());
                break;
            }
            case 6: {
                context.getRegisters().setStatement(!context.getRegisters().isStatement());
                break;
            }
            case 7: {
                context.getRegisters().setBasicBlock(true);
                break;
            }
            case 8: {
                int adjustedOpcode = 255 - context.getHeader().getOpcodeBase();
                int operationAdvance = adjustedOpcode / context.getHeader().getLineRange();
                OpcodeProcessorKt.incrementAddressAndOpIndex(context, operationAdvance);
                break;
            }
            case 9: {
                DebugLineRegisters debugLineRegisters = context.getRegisters();
                debugLineRegisters.setAddress(debugLineRegisters.getAddress() + reader.readLong(2));
                context.getRegisters().setOpIndex(0);
                break;
            }
            case 10: {
                context.getRegisters().setPrologueEnd(true);
                break;
            }
            case 11: {
                context.getRegisters().setEpilogueBegin(true);
                break;
            }
            case 12: {
                context.getRegisters().setIsa(reader.readULEB128());
            }
        }
        return standardOpcode.isNewRow();
    }
}

