/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.elf;

import com.yandex.android.appmetrica.ndk.elf.ElfClass;
import com.yandex.android.appmetrica.ndk.elf.ElfFileHeader;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeader;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeaders;
import com.yandex.android.appmetrica.ndk.elf.ElfSymbol;
import com.yandex.android.appmetrica.ndk.elf.ElfSymbolKt;
import com.yandex.android.appmetrica.ndk.elf.ElfSymbolKt$WhenMappings;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0014\u0010 \u001a\u00020\u0016*\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002\u001a\"\u0010#\u001a\u00020$*\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"SHN_ABS", "", "SHN_UNDEF", "STB_GLOBAL", "", "STB_HIOS", "STB_HIPROC", "STB_LOCAL", "STB_LOOS", "STB_LOPROC", "STB_WEAK", "STT_FILE", "STT_FUNC", "STT_HIOS", "STT_HIPROC", "STT_LOOS", "STT_LOPROC", "STT_NOTYPE", "STT_OBJECT", "STT_SECTION", "parseElfSymbols", "", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSymbol;", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "elfFileHeader", "Lcom/yandex/android/appmetrica/ndk/elf/ElfFileHeader;", "symTabSection", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSectionHeader;", "namesSection", "sectionHeaders", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSectionHeaders;", "readElfSymbol", "elfClass", "Lcom/yandex/android/appmetrica/ndk/elf/ElfClass;", "readNames", "", "namesSectionOffset", "", "appmetrica-build-plugin"})
public final class ElfSymbolKt {
    private static final int STB_LOCAL = 0;
    private static final int STB_GLOBAL = 1;
    private static final int STB_WEAK = 2;
    private static final int STB_LOOS = 10;
    private static final int STB_HIOS = 12;
    private static final int STB_LOPROC = 13;
    private static final int STB_HIPROC = 15;
    private static final int STT_NOTYPE = 0;
    private static final int STT_OBJECT = 1;
    private static final int STT_FUNC = 2;
    private static final int STT_SECTION = 3;
    private static final int STT_FILE = 4;
    private static final int STT_LOOS = 10;
    private static final int STT_HIOS = 12;
    private static final int STT_LOPROC = 13;
    private static final int STT_HIPROC = 15;
    private static final short SHN_UNDEF = 0;
    private static final short SHN_ABS = -15;

    @NotNull
    public static final List<ElfSymbol> parseElfSymbols(@NotNull ByteReader reader, @NotNull ElfFileHeader elfFileHeader, @NotNull ElfSectionHeaders sectionHeaders) throws IOException {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(elfFileHeader, "elfFileHeader");
        Intrinsics.checkParameterIsNotNull(sectionHeaders, "sectionHeaders");
        boolean bl = false;
        List symbols = new ArrayList();
        Iterable $this$forEach$iv = sectionHeaders.findHeaders(parseElfSymbols.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElfSectionHeader elfSectionHeader;
            ElfSectionHeader symTabSection = (ElfSectionHeader)element$iv;
            boolean bl2 = false;
            if (sectionHeaders.getHeaderByIndex(symTabSection.getLink()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ElfSectionHeader namesSection = elfSectionHeader;
            boolean bl5 = false;
            symbols.addAll((Collection)ElfSymbolKt.parseElfSymbols(reader, elfFileHeader, symTabSection, namesSection));
        }
        return symbols;
    }

    private static final List<ElfSymbol> parseElfSymbols(ByteReader reader, ElfFileHeader elfFileHeader, ElfSectionHeader symTabSection, ElfSectionHeader namesSection) throws IOException {
        reader.seek(symTabSection.getOffset());
        int numSymbols = (int)(symTabSection.getSize() / symTabSection.getEntrySize());
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<ElfSymbol> arrayList = new ArrayList<ElfSymbol>(numSymbols);
        boolean bl3 = false;
        int n = 0;
        n = 0;
        int n2 = numSymbols;
        while (n < n2) {
            int n3 = n++;
            boolean bl4 = false;
            int n4 = n3;
            ArrayList<ElfSymbol> arrayList2 = arrayList;
            boolean bl5 = false;
            ElfSymbol elfSymbol = ElfSymbolKt.readElfSymbol(reader, elfFileHeader.getIdent().getElfClass());
            boolean bl6 = false;
            boolean bl7 = false;
            ElfSymbol $this$apply = elfSymbol;
            boolean bl8 = false;
            $this$apply.fixValue(elfFileHeader.getMachine());
            ElfSymbol elfSymbol2 = elfSymbol;
            arrayList2.add(elfSymbol2);
        }
        List symbols = arrayList;
        ElfSymbolKt.readNames(symbols, reader, namesSection.getOffset());
        return symbols;
    }

    private static final ElfSymbol readElfSymbol(@NotNull ByteReader $this$readElfSymbol, ElfClass elfClass) throws IOException {
        ElfSymbol elfSymbol;
        switch (ElfSymbolKt$WhenMappings.$EnumSwitchMapping$0[elfClass.ordinal()]) {
            case 1: {
                int name2 = ByteReader.readInt$default($this$readElfSymbol, 0, 1, null);
                long value = $this$readElfSymbol.readLong(elfClass.getWordSize());
                long size = $this$readElfSymbol.readLong(elfClass.getWordSize());
                byte info = $this$readElfSymbol.readByte();
                byte other = $this$readElfSymbol.readByte();
                short sectionTableIndex = ByteReader.readShort$default($this$readElfSymbol, 0, 1, null);
                elfSymbol = new ElfSymbol(name2, value, size, info, other, sectionTableIndex);
                break;
            }
            case 2: {
                int name3 = ByteReader.readInt$default($this$readElfSymbol, 0, 1, null);
                byte info = $this$readElfSymbol.readByte();
                byte other = $this$readElfSymbol.readByte();
                short sectionTableIndex = ByteReader.readShort$default($this$readElfSymbol, 0, 1, null);
                long value = $this$readElfSymbol.readLong(elfClass.getWordSize());
                long size = $this$readElfSymbol.readLong(elfClass.getWordSize());
                elfSymbol = new ElfSymbol(name3, value, size, info, other, sectionTableIndex);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return elfSymbol;
    }

    private static final void readNames(@NotNull List<ElfSymbol> $this$readNames, ByteReader reader, long namesSectionOffset) throws IOException {
        Iterable $this$sortedBy$iv = $this$readNames;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ElfSymbol it = (ElfSymbol)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getName());
                it = (ElfSymbol)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getName();
                return ComparisonsKt.compareValues(comparable2, (Comparable)n);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElfSymbol symbol = (ElfSymbol)element$iv;
            boolean bl2 = false;
            reader.seek(namesSectionOffset + (long)symbol.getName());
            symbol.setNameString(reader.readNullTerminatedString(Charsets.UTF_8));
        }
    }
}

