/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.plugin;

import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.plugin.FileUploader;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yandex/android/appmetrica/plugin/FileUploader;", "", "url", "", "postApiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "retryCount", "", "uploadFile", "", "zippedFile", "Ljava/io/File;", "appmetrica-build-plugin"})
public final class FileUploader {
    private int retryCount;
    private final String url;
    private final String postApiKey;

    public final void uploadFile(@NotNull File zippedFile) {
        Intrinsics.checkParameterIsNotNull(zippedFile, "zippedFile");
        CloseableHttpClient httpclient = HttpClients.createSystem();
        HttpPut httpPut = new HttpPut(this.url);
        httpPut.setEntity((HttpEntity)new FileEntity(zippedFile));
        httpPut.addHeader("Authorization", "Post-Api-Key " + this.postApiKey);
        httpPut.addHeader("Content-Type", "application/zip; charset=utf-8");
        Log.INSTANCE.info("Executing request " + httpPut.getRequestLine());
        ResponseHandler responseHandler2 = uploadFile.responseHandler.1.INSTANCE;
        while (true) {
            try {
                String responseBody = (String)httpclient.execute((HttpUriRequest)httpPut, responseHandler2);
                Log.INSTANCE.info("Request succeeded with response body " + responseBody);
                return;
            }
            catch (HttpResponseException e) {
                int n = e.getStatusCode();
                if (500 <= n && 599 >= n) {
                    Log.INSTANCE.debug("Request failed with status code " + e.getStatusCode() + ". Retrying...");
                    ++this.retryCount;
                    continue;
                }
                throw (Throwable)e;
                if (this.retryCount < 3) continue;
                return;
            }
            break;
        }
    }

    public FileUploader(@NotNull String url, @NotNull String postApiKey2) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(postApiKey2, "postApiKey");
        this.url = url;
        this.postApiKey = postApiKey2;
    }
}

