/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.plugin.configurator;

import com.android.build.gradle.api.ApplicationVariant;
import com.yandex.android.appmetrica.plugin.extension.AppMetricaExtension;
import com.yandex.android.appmetrica.plugin.gradle.AGPVersion;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00010\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/yandex/android/appmetrica/plugin/configurator/Configurator;", "", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;", "(Lorg/gradle/api/Project;Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;)V", "getExtension", "()Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;", "getProject", "()Lorg/gradle/api/Project;", "configure", "", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "getParamsForAnalytics", "", "", "kotlin.jvm.PlatformType", "appmetrica-build-plugin"})
public abstract class Configurator {
    @NotNull
    private final Project project;
    @NotNull
    private final AppMetricaExtension extension;

    public abstract void configure(@NotNull ApplicationVariant var1);

    @NotNull
    public final Map<String, Object> getParamsForAnalytics(@NotNull ApplicationVariant variant) {
        Intrinsics.checkParameterIsNotNull(variant, "variant");
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to("offline", this.extension.getOffline().invoke(variant));
        pairArray[1] = TuplesKt.to("ndk.enable", this.extension.getNdk().getEnable().invoke(variant));
        pairArray[2] = TuplesKt.to("versionName", variant.getVersionName());
        pairArray[3] = TuplesKt.to("versionCode", variant.getVersionCode());
        pairArray[4] = TuplesKt.to("applicationId", variant.getApplicationId());
        pairArray[5] = TuplesKt.to("agp.version", AGPVersion.INSTANCE.current(this.project).toString());
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkExpressionValueIsNotNull(gradleVersion, "GradleVersion.current()");
        pairArray[6] = TuplesKt.to("gradle.version", gradleVersion.getVersion());
        return MapsKt.mapOf(pairArray);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final AppMetricaExtension getExtension() {
        return this.extension;
    }

    public Configurator(@NotNull Project project, @NotNull AppMetricaExtension extension) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        this.project = project;
        this.extension = extension;
    }
}

