/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.plugin.configurator;

import com.android.build.gradle.api.ApplicationVariant;
import com.android.builder.model.BuildType;
import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.plugin.BuildUuidHelper;
import com.yandex.android.appmetrica.plugin.UploadTask;
import com.yandex.android.appmetrica.plugin.configurator.Configurator;
import com.yandex.android.appmetrica.plugin.extension.AppMetricaExtension;
import com.yandex.android.appmetrica.plugin.provider.BuildInfoFileProvider;
import com.yandex.android.appmetrica.plugin.provider.FileProvider;
import com.yandex.android.appmetrica.plugin.provider.SymbolsFileProvider;
import com.yandex.android.appmetrica.plugin.provider.ZipFileProvider;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/yandex/android/appmetrica/plugin/configurator/NdkConfigurator;", "Lcom/yandex/android/appmetrica/plugin/configurator/Configurator;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;", "(Lorg/gradle/api/Project;Lcom/yandex/android/appmetrica/plugin/extension/AppMetricaExtension;)V", "configure", "", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "appmetrica-build-plugin"})
public final class NdkConfigurator
extends Configurator {
    @Override
    public void configure(@NotNull ApplicationVariant variant) {
        Intrinsics.checkParameterIsNotNull(variant, "variant");
        Log.INSTANCE.info("Configuring ndk " + variant.getName());
        this.getProject().getDependencies().add(variant.getName() + "Implementation", (Object)"com.yandex.android:mobmetricalib-ndk-crashes:1.1.0");
        String buildId = BuildUuidHelper.INSTANCE.getBuildUuid(variant);
        TaskContainer taskContainer = this.getProject().getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("upload");
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "variant.name");
        taskContainer.create(stringBuilder.append(StringsKt.capitalize(string)).append("Symbols").toString(), UploadTask.class, (Action)new Action<UploadTask>(this, variant, buildId){
            final /* synthetic */ NdkConfigurator this$0;
            final /* synthetic */ ApplicationVariant $variant;
            final /* synthetic */ String $buildId;

            public final void execute(UploadTask task) {
                task.setUploadUrl("https://api.appmetrica.yandex.ru/management/v1/application/crash/android_native/upload");
                task.setPostApiKey(this.this$0.getExtension().getPostApiKey().invoke(this.$variant));
                task.setOffline(this.this$0.getExtension().getOffline().invoke(this.$variant));
                List<FileProvider> list = CollectionsKt.listOf(new BuildInfoFileProvider(this.this$0.getProject(), this.$buildId, this.$variant), new SymbolsFileProvider(this.$variant, this.this$0.getExtension().getNdk()));
                File file = this.this$0.getProject().getBuildDir();
                Intrinsics.checkExpressionValueIsNotNull(file, "project.buildDir");
                String string = file.getAbsolutePath();
                String[] stringArray = new String[3];
                stringArray[0] = "symbols";
                stringArray[1] = this.$variant.getFlavorName();
                BuildType buildType = this.$variant.getBuildType();
                Intrinsics.checkExpressionValueIsNotNull(buildType, "variant.buildType");
                stringArray[2] = buildType.getName();
                File file2 = Paths.get(string, stringArray).toFile();
                Intrinsics.checkExpressionValueIsNotNull(file2, "Paths.get(project.buildD\u2026.buildType.name).toFile()");
                task.setFileProvider(new ZipFileProvider(list, file2));
                task.setEnableAnalytics(this.this$0.getExtension().getEnableAnalytics());
                task.setParamsForAnalytics(MapsKt.plus(MapsKt.mapOf(TuplesKt.to("task_type", "upload_ndk")), this.this$0.getParamsForAnalytics(this.$variant)));
            }
            {
                this.this$0 = ndkConfigurator;
                this.$variant = applicationVariant;
                this.$buildId = string;
            }
        });
    }

    public NdkConfigurator(@NotNull Project project, @NotNull AppMetricaExtension extension) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        super(project, extension);
    }
}

