/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk;

import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.ndk.YSym;
import com.yandex.android.appmetrica.ndk.YSymException;
import com.yandex.android.appmetrica.ndk.YSymFactory;
import com.yandex.android.appmetrica.ndk.dwarf.info.CompilationUnitContext;
import com.yandex.android.appmetrica.ndk.dwarf.info.range.NamedRanges;
import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineContext;
import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineData;
import com.yandex.android.appmetrica.ndk.dwarf.line.DebugLineEntry;
import com.yandex.android.appmetrica.ndk.elf.ElfFileHeader;
import com.yandex.android.appmetrica.ndk.elf.ElfHandler;
import com.yandex.android.appmetrica.ndk.elf.ElfMachine;
import com.yandex.android.appmetrica.ndk.elf.ElfParserKt;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeaders;
import com.yandex.android.appmetrica.ndk.elf.ElfSymbol;
import com.yandex.android.appmetrica.ndk.io.StringUtilsKt;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/yandex/android/appmetrica/ndk/ElfYSymFactory;", "Lcom/yandex/android/appmetrica/ndk/YSymFactory;", "()V", "createCSymFromFile", "Lcom/yandex/android/appmetrica/ndk/YSym;", "binFile", "Ljava/io/File;", "YSymFactoryHandler", "appmetrica-build-plugin"})
public final class ElfYSymFactory
implements YSymFactory {
    @Override
    @NotNull
    public YSym createCSymFromFile(@NotNull File binFile) throws YSymException, IOException {
        Intrinsics.checkParameterIsNotNull(binFile, "binFile");
        Log.INSTANCE.debug("Processing file " + binFile.getAbsolutePath());
        if (!binFile.isFile()) {
            throw (Throwable)new IllegalArgumentException("Invalid object file: " + binFile);
        }
        YSymFactoryHandler handler = new YSymFactoryHandler();
        ElfParserKt.parseElf(binFile, (ElfHandler)handler);
        return handler.getBuilder().build();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u001c\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\u0016\u0010(\u001a\u00020\u0006*\u00020)2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\f\u0010(\u001a\u00020\u0006*\u00020\u001cH\u0002J\f\u0010,\u001a\u00020\u0006*\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/yandex/android/appmetrica/ndk/ElfYSymFactory$YSymFactoryHandler;", "Lcom/yandex/android/appmetrica/ndk/elf/ElfHandler;", "()V", "arch", "Lcom/yandex/android/appmetrica/ndk/elf/ElfMachine;", "archName", "", "<set-?>", "Lcom/yandex/android/appmetrica/ndk/YSym$Builder;", "builder", "getBuilder", "()Lcom/yandex/android/appmetrica/ndk/YSym$Builder;", "codeId", "hasDebugInfo", "", "identifier", "isArm", "endProcessingSymbols", "", "processArmVersion", "armVersion", "processDebugInfoCompilationUnit", "debugInfoCompilationUnits", "", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/CompilationUnitContext;", "Lcom/yandex/android/appmetrica/ndk/dwarf/line/DebugLineData;", "processElfBuildId", "byteArray", "", "processElfHeader", "fileHeader", "Lcom/yandex/android/appmetrica/ndk/elf/ElfFileHeader;", "processElfSymbols", "elfSymbols", "", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSymbol;", "processSectionHeaders", "sectionHeaders", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSectionHeaders;", "startProcessingSymbols", "toHexString", "", "size", "", "toUuidString", "appmetrica-build-plugin"})
    private static final class YSymFactoryHandler
    implements ElfHandler {
        @NotNull
        private YSym.Builder builder;
        private ElfMachine arch;
        private String archName;
        private boolean isArm;
        private boolean hasDebugInfo;
        private String identifier;
        private String codeId;

        @NotNull
        public final YSym.Builder getBuilder() {
            YSym.Builder builder = this.builder;
            if (builder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
            }
            return builder;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void processElfHeader(@NotNull ElfFileHeader fileHeader) {
            Intrinsics.checkParameterIsNotNull(fileHeader, "fileHeader");
            Log.INSTANCE.debug("Processing elf file header : " + StringUtilsKt.toPrettyString(fileHeader));
            v0 = this.arch = fileHeader.getMachine();
            if (v0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("arch");
            }
            if (v0 == ElfMachine.EM_ARM) ** GOTO lbl-1000
            v1 = this.arch;
            if (v1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("arch");
            }
            if (v1 == ElfMachine.EM_AARCH64) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.isArm = v2;
            this.archName = fileHeader.getMachine().getArchName();
        }

        @Override
        public void processSectionHeaders(@NotNull ElfSectionHeaders sectionHeaders) {
            Intrinsics.checkParameterIsNotNull(sectionHeaders, "sectionHeaders");
            Log.INSTANCE.debug("Processing section headers");
            StringUtilsKt.print(sectionHeaders, (Function1<? super String, Unit>)new Function1<String, Unit>(Log.INSTANCE){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    ((Log)this.receiver).debug(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Log.class);
                }

                public final String getName() {
                    return "debug";
                }

                public final String getSignature() {
                    return "debug(Ljava/lang/String;)V";
                }
            });
            this.hasDebugInfo = sectionHeaders.hasDebugInfo();
        }

        @Override
        public void processElfBuildId(@Nullable byte[] byteArray) {
            if (byteArray == null) {
                throw (Throwable)new YSymException("Not found ELF build id");
            }
            Log.INSTANCE.debug("Processing elf build id : " + StringUtilsKt.toPrettyString(byteArray));
            this.identifier = this.toUuidString(byteArray) + "0";
            StringBuilder stringBuilder = new StringBuilder().append("UUID: ");
            String string = this.identifier;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("identifier");
            }
            Log.INSTANCE.debug(stringBuilder.append(string).toString());
            this.codeId = this.toHexString(byteArray);
            StringBuilder stringBuilder2 = new StringBuilder().append("Code id: ");
            String string2 = this.codeId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("codeId");
            }
            Log.INSTANCE.debug(stringBuilder2.append(string2).toString());
        }

        @Override
        public void processArmVersion(@NotNull String armVersion) {
            Intrinsics.checkParameterIsNotNull(armVersion, "armVersion");
            Log.INSTANCE.debug("Processing elf arm version : " + armVersion);
            ElfMachine elfMachine = this.arch;
            if (elfMachine == null) {
                Intrinsics.throwUninitializedPropertyAccessException("arch");
            }
            if (elfMachine == ElfMachine.EM_ARM) {
                String string = this.archName;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("archName");
                }
                this.archName = string + 'v' + armVersion;
            }
        }

        @Override
        public void startProcessingSymbols() {
            Log.INSTANCE.debug(StringsKt.trimIndent("\n                =================================================================================\n                Start processing symbols " + (this.hasDebugInfo ? "using ELF symbols and DWARF elfData for ySYM generation." : "using ELF elfData for ySYM generation.") + "\n                =================================================================================\n            "));
            String string = this.identifier;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("identifier");
            }
            String string2 = this.codeId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("codeId");
            }
            String string3 = this.archName;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("archName");
            }
            this.builder = new YSym.Builder(string, string2, string3);
        }

        @Override
        public void processElfSymbols(@NotNull List<ElfSymbol> elfSymbols) {
            Intrinsics.checkParameterIsNotNull(elfSymbols, "elfSymbols");
            Log.INSTANCE.debug("Processing elf symbols");
            StringUtilsKt.print(elfSymbols, (Function1<? super String, Unit>)new Function1<String, Unit>(Log.INSTANCE){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    ((Log)this.receiver).debug(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Log.class);
                }

                public final String getName() {
                    return "debug";
                }

                public final String getSignature() {
                    return "debug(Ljava/lang/String;)V";
                }
            });
            Iterable $this$forEach$iv = elfSymbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ElfSymbol it = (ElfSymbol)element$iv;
                boolean bl = false;
                YSym.Builder builder = this.builder;
                if (builder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("builder");
                }
                builder.addSymbol(it);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processDebugInfoCompilationUnit(@NotNull Map<CompilationUnitContext, DebugLineData> debugInfoCompilationUnits) {
            Intrinsics.checkParameterIsNotNull(debugInfoCompilationUnits, "debugInfoCompilationUnits");
            Log.INSTANCE.debug("Processing debug info compilation units");
            Map<CompilationUnitContext, DebugLineData> $this$forEach$iv = debugInfoCompilationUnits;
            boolean $i$f$forEach = false;
            Map<CompilationUnitContext, DebugLineData> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<CompilationUnitContext, DebugLineData>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                List list;
                Iterable destination$iv$iv;
                Iterator it;
                Collection<String> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                Map.Entry<CompilationUnitContext, DebugLineData> element$iv;
                Map.Entry<CompilationUnitContext, DebugLineData> $dstr$context$debugLineData = element$iv = iterator2.next();
                boolean bl2 = false;
                Object object = $dstr$context$debugLineData;
                boolean bl3 = false;
                CompilationUnitContext context = object.getKey();
                object = $dstr$context$debugLineData;
                bl3 = false;
                DebugLineData debugLineData = object.getValue();
                Log.INSTANCE.debug("Processing debug info compilation unit : " + context.getName());
                object = context.getSubPrograms();
                Object object2 = new StringBuilder().append("Subprogram symbol names : ");
                Object object3 = Log.INSTANCE;
                boolean $i$f$map = false;
                void var16_17 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    YSym.SubProgram subProgram = (YSym.SubProgram)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    String string = ((YSym.SubProgram)((Object)it)).getName().getSymbolName();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv2;
                ((Log)object3).debug(((StringBuilder)object2).append(StringUtilsKt.toPrettyString(collection)).toString());
                NamedRanges namedRanges = new NamedRanges(context.getNamedRanges());
                Object object4 = debugLineData.getDebugLineContext();
                if (object4 != null && (object4 = ((DebugLineContext)object4).getFiles()) != null) {
                    void $this$mapTo$iv$iv3;
                    Iterable $this$map$iv2 = (Iterable)object4;
                    boolean $i$f$map2 = false;
                    Iterable $i$f$mapTo2 = $this$map$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo3 = false;
                    it = $this$mapTo$iv$iv3.iterator();
                    while (it.hasNext()) {
                        void it2;
                        Object item$iv$iv = it.next();
                        DebugLineContext.DebugLineFileInfo debugLineFileInfo = (DebugLineContext.DebugLineFileInfo)item$iv$iv;
                        object3 = destination$iv$iv;
                        boolean bl5 = false;
                        object2 = it2.getDirectory() + '/' + it2.getName();
                        object3.add(object2);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List files = list;
                Log.INSTANCE.debug("Debug line context file names : " + StringUtilsKt.toPrettyString(files));
                Iterable $this$map$iv3 = debugLineData.getDebugLineEntries();
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    DebugLineEntry bl5 = (DebugLineEntry)item$iv$iv;
                    object3 = destination$iv$iv3;
                    boolean bl6 = false;
                    object2 = new YSym.Line(it3.getAddress(), it3.getFile(), it3.getLineNumber(), it3.getColumnNumber(), it3.getEndSequence());
                    object3.add(object2);
                }
                List lines = (List)destination$iv$iv3;
                YSym.Builder builder = this.builder;
                if (builder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("builder");
                }
                builder.addCompileUnit(new YSym.CompileUnit(context.getName(), context.getRanges(), files, lines, context.getSubPrograms()));
            }
        }

        @Override
        public void endProcessingSymbols() {
            Log.INSTANCE.debug("=================================================================================\nEnd processing symbols\n=================================================================================");
        }

        private final String toHexString(@NotNull byte[] $this$toHexString) {
            return ArraysKt.joinToString$default($this$toHexString, (CharSequence)"", null, null, 0, null, (Function1)new Function1<Byte, String>(this){
                final /* synthetic */ YSymFactoryHandler this$0;

                @NotNull
                public final String invoke(byte it) {
                    return YSymFactoryHandler.access$toHexString(this.this$0, it, 2);
                }
                {
                    this.this$0 = ySymFactoryHandler;
                    super(1);
                }
            }, 30, null);
        }

        private final String toHexString(byte $this$toHexString, int size) {
            byte by = $this$toHexString;
            boolean bl = false;
            String string = StringsKt.padStart(UStringsKt.toString-LxnNnR4(UByte.constructor-impl(by), 16), size, '0');
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toUpperCase()");
            return string3;
        }

        static /* synthetic */ String toHexString$default(YSymFactoryHandler ySymFactoryHandler, byte by, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return ySymFactoryHandler.toHexString(by, n);
        }

        private final String toUuidString(@NotNull byte[] $this$toUuidString) {
            byte[] bytes = $this$toUuidString;
            if (Intrinsics.areEqual(ByteOrder.nativeOrder(), ByteOrder.BIG_ENDIAN)) {
                return this.toHexString(bytes);
            }
            byte[] byArray = bytes;
            int n = 16;
            boolean bl = false;
            byte[] byArray2 = Arrays.copyOf(byArray, n);
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "java.util.Arrays.copyOf(this, newSize)");
            byte[] extendedBytes = byArray2;
            n = 0;
            List answer = new ArrayList();
            Collection collection = answer;
            Iterable iterable = CollectionsKt.reversed((Iterable)ArraysKt.slice(extendedBytes, RangesKt.until(0, 4)));
            boolean bl2 = false;
            CollectionsKt.addAll(collection, iterable);
            collection = answer;
            iterable = CollectionsKt.reversed((Iterable)ArraysKt.slice(extendedBytes, RangesKt.until(4, 6)));
            bl2 = false;
            CollectionsKt.addAll(collection, iterable);
            collection = answer;
            iterable = CollectionsKt.reversed((Iterable)ArraysKt.slice(extendedBytes, RangesKt.until(6, 8)));
            bl2 = false;
            CollectionsKt.addAll(collection, iterable);
            collection = answer;
            iterable = ArraysKt.slice(extendedBytes, RangesKt.until(8, 16));
            bl2 = false;
            CollectionsKt.addAll(collection, iterable);
            return this.toHexString(CollectionsKt.toByteArray(answer));
        }

        public static final /* synthetic */ String access$toHexString(YSymFactoryHandler $this, byte $this$access_u24toHexString, int size) {
            return $this.toHexString($this$access_u24toHexString, size);
        }
    }
}

