/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.dwarf.info;

import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.ndk.YSym;
import com.yandex.android.appmetrica.ndk.dwarf.DwarfException;
import com.yandex.android.appmetrica.ndk.dwarf.FileContext;
import com.yandex.android.appmetrica.ndk.dwarf.abbrev.DebugAbbrevAttribute;
import com.yandex.android.appmetrica.ndk.dwarf.abbrev.DebugAbbrevEntry;
import com.yandex.android.appmetrica.ndk.dwarf.abbrev.DebugAbbrevParserKt;
import com.yandex.android.appmetrica.ndk.dwarf.info.CompilationUnitContext;
import com.yandex.android.appmetrica.ndk.dwarf.info.CompilationUnitHeader;
import com.yandex.android.appmetrica.ndk.dwarf.info.CompilationUnitHeaderKt;
import com.yandex.android.appmetrica.ndk.dwarf.info.DebugInfoParserKt$WhenMappings;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.processor.CompileUnitAttributeProcessor;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.processor.InlineSubroutineAttributeProcessor;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.processor.SubProgramAttributeProcessor;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.reader.DebugAttributesReader;
import com.yandex.android.appmetrica.ndk.dwarf.info.attribute.reader.SkipAttributesReader;
import com.yandex.android.appmetrica.ndk.dwarf.info.range.NamedRangesResolver;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeader;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u001aH\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u001a4\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002\u001a.\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u001a6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00012\u0006\u0010\u000b\u001a\u00020\tH\u0002\u001a.\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u001aI\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u001c0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010!\u001a&\u0010\"\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u00a8\u0006$"}, d2={"parseChildEntries", "", "Lcom/yandex/android/appmetrica/ndk/YSym$SubProgram;", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "context", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/CompilationUnitContext;", "abbrevEntries", "", "", "Lcom/yandex/android/appmetrica/ndk/dwarf/abbrev/DebugAbbrevEntry;", "depth", "subProgram", "parseCompilationUnit", "fileContext", "Lcom/yandex/android/appmetrica/ndk/dwarf/FileContext;", "header", "Lcom/yandex/android/appmetrica/ndk/dwarf/info/CompilationUnitHeader;", "parseCompilationUnitEntry", "attributes", "Lcom/yandex/android/appmetrica/ndk/dwarf/abbrev/DebugAbbrevAttribute;", "parseDebugInfo", "parseInline", "Lcom/yandex/android/appmetrica/ndk/YSym$Inline;", "entryOffset", "", "parseSubProgram", "resolveRanges", "Lkotlin/Pair;", "addressSize", "rangesSectionOffset", "offset", "baseAddress", "(Lcom/yandex/android/appmetrica/ndk/io/ByteReader;IJLjava/lang/Long;J)Ljava/util/List;", "skip", "", "appmetrica-build-plugin"})
public final class DebugInfoParserKt {
    @NotNull
    public static final List<CompilationUnitContext> parseDebugInfo(@NotNull ByteReader reader, @NotNull FileContext fileContext) throws IOException, DwarfException {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(fileContext, "fileContext");
        ElfSectionHeader debugInfoHeader = fileContext.getDebugHeaders().getDebugInfo();
        reader.seek(debugInfoHeader.getOffset());
        long sectionEndOffset = debugInfoHeader.getOffset() + debugInfoHeader.getSize();
        boolean bl = false;
        List compilationUnitContexts = new ArrayList();
        while (reader.getCurrentOffset() != sectionEndOffset) {
            compilationUnitContexts.add(DebugInfoParserKt.parseCompilationUnit(reader, fileContext));
        }
        return compilationUnitContexts;
    }

    @NotNull
    public static final CompilationUnitContext parseCompilationUnit(@NotNull ByteReader reader, @NotNull FileContext fileContext) throws IOException, DwarfException {
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(fileContext, "fileContext");
        CompilationUnitHeader header = CompilationUnitHeaderKt.readCompilationUnitHeader(reader, fileContext.getDebugHeaders().getDebugInfo().getOffset());
        long debugAbbrevOffset = fileContext.getDebugHeaders().getDebugAbbrev().getOffset() + header.getAbbrevOffset();
        return DebugInfoParserKt.parseCompilationUnit(reader, fileContext, header, DebugAbbrevParserKt.parseAbbrevSection(reader, debugAbbrevOffset));
    }

    private static final CompilationUnitContext parseCompilationUnit(ByteReader reader, FileContext fileContext, CompilationUnitHeader header, Map<Integer, DebugAbbrevEntry> abbrevEntries) throws IOException, DwarfException {
        int abbrevCode = reader.readULEB128();
        Map<Integer, DebugAbbrevEntry> map = abbrevEntries;
        Integer n = abbrevCode;
        boolean bl = false;
        DebugAbbrevEntry debugAbbrevEntry = map.get(n);
        if (debugAbbrevEntry == null) {
            boolean bl2 = false;
            throw (Throwable)new DwarfException("Unrecognized abbreviations code: " + abbrevCode);
        }
        DebugAbbrevEntry abbrevEntry = debugAbbrevEntry;
        CompilationUnitContext context = DebugInfoParserKt.parseCompilationUnitEntry(reader, fileContext, header, abbrevEntry.getAttributes());
        if (abbrevEntry.getHasChildren()) {
            context.getSubPrograms().addAll(DebugInfoParserKt.parseChildEntries$default(reader, context, abbrevEntries, 0, null, 24, null));
        }
        return context;
    }

    private static final List<YSym.SubProgram> parseChildEntries(ByteReader reader, CompilationUnitContext context, Map<Integer, DebugAbbrevEntry> abbrevEntries, int depth, YSym.SubProgram subProgram) throws IOException, DwarfException {
        boolean bl = false;
        List subPrograms = new ArrayList();
        long debugInfoOffset = context.getFileContext().getDebugHeaders().getDebugInfo().getOffset();
        Ref.IntRef abbrevCode = new Ref.IntRef();
        Ref.LongRef longRef = new Ref.LongRef();
        block4: while (true) {
            DebugAbbrevEntry abbrevEntry;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            longRef.element = reader.getCurrentOffset() - debugInfoOffset;
            abbrevCode.element = reader.readULEB128();
            if (!(abbrevCode.element > 0)) break;
            Map<Integer, DebugAbbrevEntry> map = abbrevEntries;
            Integer n = abbrevCode.element;
            boolean bl5 = false;
            if (map.get(n) == null) {
                boolean bl6 = false;
                throw (Throwable)new DwarfException("Unrecognized abbreviations code: " + abbrevCode.element);
            }
            switch (DebugInfoParserKt$WhenMappings.$EnumSwitchMapping$0[abbrevEntry.getTag().ordinal()]) {
                case 1: {
                    YSym.SubProgram curSubProgram = DebugInfoParserKt.parseSubProgram(reader, context, longRef.element, abbrevEntry.getAttributes());
                    subPrograms.add(curSubProgram);
                    if (!abbrevEntry.getHasChildren()) continue block4;
                    subPrograms.addAll((Collection)DebugInfoParserKt.parseChildEntries(reader, context, abbrevEntries, 1, curSubProgram));
                    continue block4;
                }
                case 2: {
                    YSym.Inline inline = DebugInfoParserKt.parseInline(reader, context, longRef.element, abbrevEntry.getAttributes(), depth);
                    YSym.SubProgram subProgram2 = subProgram;
                    if (subProgram2 != null) {
                        subProgram2.addInline(inline);
                    }
                    if (!abbrevEntry.getHasChildren()) continue block4;
                    subPrograms.addAll((Collection)DebugInfoParserKt.parseChildEntries(reader, context, abbrevEntries, depth + 1, subProgram));
                    continue block4;
                }
            }
            DebugInfoParserKt.skip(reader, context, abbrevEntry.getAttributes());
            if (!abbrevEntry.getHasChildren()) continue;
            subPrograms.addAll((Collection)DebugInfoParserKt.parseChildEntries(reader, context, abbrevEntries, depth, subProgram));
        }
        return subPrograms;
    }

    static /* synthetic */ List parseChildEntries$default(ByteReader byteReader, CompilationUnitContext compilationUnitContext, Map map, int n, YSym.SubProgram subProgram, int n2, Object object) throws IOException, DwarfException {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            subProgram = null;
        }
        return DebugInfoParserKt.parseChildEntries(byteReader, compilationUnitContext, map, n, subProgram);
    }

    private static final YSym.SubProgram parseSubProgram(ByteReader reader, CompilationUnitContext context, long entryOffset, List<DebugAbbrevAttribute> attributes) throws IOException {
        int n = context.getHeader().getAddressSize();
        ElfSectionHeader elfSectionHeader = context.getFileContext().getDebugHeaders().getDebugRanges();
        if (elfSectionHeader == null) {
            Intrinsics.throwNpe();
        }
        NamedRangesResolver namedRangesResolver = new NamedRangesResolver(reader, n, elfSectionHeader.getOffset());
        SubProgramAttributeProcessor attributeProcessor = new SubProgramAttributeProcessor(entryOffset, context, namedRangesResolver);
        DebugAttributesReader attributesReader = new DebugAttributesReader(reader, context.getHeader(), context.getFileContext().getReferenceBytesConverter(), attributeProcessor, context.getFileContext().getDebugHeaders().getDebugStr().getOffset());
        return (YSym.SubProgram)attributesReader.readAttributes(attributes);
    }

    private static final YSym.Inline parseInline(ByteReader reader, CompilationUnitContext context, long entryOffset, List<DebugAbbrevAttribute> attributes, int depth) {
        int n = context.getHeader().getAddressSize();
        ElfSectionHeader elfSectionHeader = context.getFileContext().getDebugHeaders().getDebugRanges();
        if (elfSectionHeader == null) {
            Intrinsics.throwNpe();
        }
        NamedRangesResolver namedRangesResolver = new NamedRangesResolver(reader, n, elfSectionHeader.getOffset());
        InlineSubroutineAttributeProcessor attributeProcessor = new InlineSubroutineAttributeProcessor(entryOffset, context, namedRangesResolver, depth);
        DebugAttributesReader attributesReader = new DebugAttributesReader(reader, context.getHeader(), context.getFileContext().getReferenceBytesConverter(), attributeProcessor, context.getFileContext().getDebugHeaders().getDebugStr().getOffset());
        return (YSym.Inline)attributesReader.readAttributes(attributes);
    }

    private static final void skip(ByteReader reader, CompilationUnitContext context, List<DebugAbbrevAttribute> attributes) {
        new SkipAttributesReader(reader, context.getHeader()).readAttributes(attributes);
    }

    private static final CompilationUnitContext parseCompilationUnitEntry(ByteReader reader, FileContext fileContext, CompilationUnitHeader header, List<DebugAbbrevAttribute> attributes) throws IOException {
        Object object;
        CompilationUnitContext.EntryData entryData;
        block5: {
            block4: {
                CompileUnitAttributeProcessor attributeProcessor = new CompileUnitAttributeProcessor(fileContext.getReferenceBytesConverter());
                DebugAttributesReader attributesReader = new DebugAttributesReader(reader, header, fileContext.getReferenceBytesConverter(), attributeProcessor, fileContext.getDebugHeaders().getDebugStr().getOffset());
                entryData = (CompilationUnitContext.EntryData)attributesReader.readAttributes(attributes);
                object = entryData.getRangesSecOffset();
                if (object == null) break block4;
                Long l = object;
                boolean bl = false;
                boolean bl2 = false;
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                int n = header.getAddressSize();
                ElfSectionHeader elfSectionHeader = fileContext.getDebugHeaders().getDebugRanges();
                if (elfSectionHeader == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = DebugInfoParserKt.resolveRanges(reader, n, elfSectionHeader.getOffset(), it, entryData.getLowPc())) != null) break block5;
            }
            object = CollectionsKt.listOf(TuplesKt.to(entryData.getLowPc(), entryData.getHighPc()));
        }
        List<Pair<Long, Long>> ranges = object;
        return new CompilationUnitContext(fileContext, header, entryData, ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Pair<Long, Long>> resolveRanges(ByteReader reader, int addressSize, long rangesSectionOffset, Long offset, long baseAddress) {
        if (offset == null) {
            return CollectionsKt.emptyList();
        }
        long originalOffset = reader.getCurrentOffset();
        boolean bl = false;
        List ranges = new ArrayList();
        try {
            reader.seek(rangesSectionOffset + offset);
            long currentBaseAddress = baseAddress;
            while (true) {
                long beginAddress = reader.readLong(addressSize);
                long endAddress = reader.readLong(addressSize);
                if (beginAddress == 0L && endAddress == 0L) {
                    break;
                }
                if (beginAddress == -1L) {
                    currentBaseAddress = endAddress;
                    continue;
                }
                ranges.add(TuplesKt.to(beginAddress += currentBaseAddress, endAddress += currentBaseAddress));
            }
        }
        catch (IOException e) {
            Log.INSTANCE.debug("Could not properly resolve range entries " + e);
        }
        finally {
            reader.seek(originalOffset);
        }
        return ranges;
    }
}

