/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.elf;

import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.ndk.elf.ElfArmVersionKt;
import com.yandex.android.appmetrica.ndk.elf.ElfFileHeader;
import com.yandex.android.appmetrica.ndk.elf.ElfMachine;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeader;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeaders;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0017"}, d2={"ARM_AEABI_ATTRIBUTES_SUBSECTION", "", "ARM_FORMAT_VERSION", "", "ARM_TAG_FILE_ATTRIBUTE", "armArch", "", "[Ljava/lang/String;", "parseArmVersion", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "elfFileHeader", "Lcom/yandex/android/appmetrica/ndk/elf/ElfFileHeader;", "sectionHeaders", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSectionHeaders;", "parseArmVersionFromAeabiAttributesSubsection", "sectionRemaining", "", "parseArmVersionFromArmAttributesSection", "sectionOffset", "size", "parseArmVersionFromTagFileAttribute", "aeabiSectionRemaining", "appmetrica-build-plugin"})
public final class ElfArmVersionKt {
    private static final String[] armArch = new String[]{"Pre-v4", "4", "4T", "5T", "5TE", "5TEJ", "6", "6KZ", "6T2", "6K", "7", "6-M", "6S-M", "7E-M", "8"};
    private static final byte ARM_FORMAT_VERSION = 65;
    private static final String ARM_AEABI_ATTRIBUTES_SUBSECTION = "aeabi";
    private static final byte ARM_TAG_FILE_ATTRIBUTE = 1;

    @Nullable
    public static final String parseArmVersion(@NotNull ByteReader reader, @NotNull ElfFileHeader elfFileHeader, @NotNull ElfSectionHeaders sectionHeaders) throws IOException {
        String string;
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        Intrinsics.checkParameterIsNotNull(elfFileHeader, "elfFileHeader");
        Intrinsics.checkParameterIsNotNull(sectionHeaders, "sectionHeaders");
        if (elfFileHeader.getMachine() == ElfMachine.EM_ARM) {
            ElfSectionHeader elfSectionHeader = sectionHeaders.findHeader(parseArmVersion.1.INSTANCE);
            if (elfSectionHeader != null) {
                ElfSectionHeader elfSectionHeader2 = elfSectionHeader;
                boolean bl = false;
                boolean bl2 = false;
                ElfSectionHeader $this$run = elfSectionHeader2;
                boolean bl3 = false;
                string = ElfArmVersionKt.parseArmVersionFromArmAttributesSection(reader, $this$run.getOffset(), $this$run.getSize());
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    private static final String parseArmVersionFromArmAttributesSection(ByteReader reader, long sectionOffset, long size) throws IOException {
        reader.seek(sectionOffset);
        byte version = reader.readByte();
        if (version != 65) {
            throw (Throwable)new IllegalArgumentException("Invalid arm format-version");
        }
        long dataRemaining = size - 1L;
        while (dataRemaining > 0L) {
            long sectionRemaining = reader.readLong(4);
            if (sectionRemaining > dataRemaining) {
                throw (Throwable)new IOException("Section size " + sectionRemaining + " is greater than remaining section length " + dataRemaining + '.');
            }
            dataRemaining -= sectionRemaining;
            sectionRemaining -= (long)4;
            String sectionName = reader.readNullTerminatedString(Charsets.UTF_8);
            sectionRemaining -= (long)(sectionName.length() - 1);
            if (Intrinsics.areEqual(sectionName, ARM_AEABI_ATTRIBUTES_SUBSECTION)) {
                return ElfArmVersionKt.parseArmVersionFromAeabiAttributesSubsection(reader, sectionRemaining);
            }
            reader.seek(reader.getCurrentOffset() + sectionRemaining);
        }
        Log.INSTANCE.debug("Did not find an ARM aeabi attributes subsection.");
        return null;
    }

    private static final String parseArmVersionFromAeabiAttributesSubsection(ByteReader reader, long sectionRemaining) throws IOException {
        long sectionRemaining2 = sectionRemaining;
        while (sectionRemaining2 > 0L) {
            byte tag = reader.readByte();
            long aeabiSectionRemaining = reader.readLong(4);
            if (aeabiSectionRemaining > sectionRemaining2) {
                throw (Throwable)new IOException("Subsection size " + aeabiSectionRemaining + " is greater than parent section size " + sectionRemaining2 + '.');
            }
            sectionRemaining2 -= aeabiSectionRemaining;
            aeabiSectionRemaining -= (long)5;
            if (tag == 1) {
                return ElfArmVersionKt.parseArmVersionFromTagFileAttribute(reader, aeabiSectionRemaining);
            }
            reader.seek(reader.getCurrentOffset() + aeabiSectionRemaining);
        }
        Log.INSTANCE.debug("Did not find an ARM file attribute subsection.");
        return null;
    }

    private static final String parseArmVersionFromTagFileAttribute(ByteReader reader, long aeabiSectionRemaining) throws IOException {
        long nextSubSection = reader.getCurrentOffset() + aeabiSectionRemaining;
        block4: while (reader.getCurrentOffset() < nextSubSection) {
            int attrTag = reader.readULEB128();
            switch (attrTag) {
                case 4: 
                case 5: 
                case 32: 
                case 65: 
                case 67: {
                    reader.readNullTerminatedString(Charsets.UTF_8);
                    continue block4;
                }
                case 6: {
                    return armArch[reader.readULEB128()];
                }
            }
            reader.readULEB128();
        }
        Log.INSTANCE.debug("Did not find an ARM architecture field.");
        return null;
    }
}

