/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.elf;

import com.yandex.android.appmetrica.Log;
import com.yandex.android.appmetrica.ndk.dwarf.DwarfException;
import com.yandex.android.appmetrica.ndk.dwarf.DwarfParserKt;
import com.yandex.android.appmetrica.ndk.elf.DebugElfSectionHeaders;
import com.yandex.android.appmetrica.ndk.elf.ElfArmVersionKt;
import com.yandex.android.appmetrica.ndk.elf.ElfException;
import com.yandex.android.appmetrica.ndk.elf.ElfFileHeader;
import com.yandex.android.appmetrica.ndk.elf.ElfFileHeaderKt;
import com.yandex.android.appmetrica.ndk.elf.ElfFileIdent;
import com.yandex.android.appmetrica.ndk.elf.ElfFileIdentKt;
import com.yandex.android.appmetrica.ndk.elf.ElfHandler;
import com.yandex.android.appmetrica.ndk.elf.ElfProgramHeaders;
import com.yandex.android.appmetrica.ndk.elf.ElfProgramHeadersKt;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeaders;
import com.yandex.android.appmetrica.ndk.elf.ElfSectionHeadersKt;
import com.yandex.android.appmetrica.ndk.elf.ElfSymbolKt;
import com.yandex.android.appmetrica.ndk.elf.ElfUuidKt;
import com.yandex.android.appmetrica.ndk.io.ByteReader;
import com.yandex.android.appmetrica.ndk.io.RandomAccessFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"parseElf", "", "reader", "Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "ident", "Lcom/yandex/android/appmetrica/ndk/elf/ElfFileIdent;", "handler", "Lcom/yandex/android/appmetrica/ndk/elf/ElfHandler;", "input", "Ljava/io/File;", "parseElfSymbols", "elfFileHeader", "Lcom/yandex/android/appmetrica/ndk/elf/ElfFileHeader;", "sectionHeaders", "Lcom/yandex/android/appmetrica/ndk/elf/ElfSectionHeaders;", "appmetrica-build-plugin"})
public final class ElfParserKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseElf(@NotNull File input, @NotNull ElfHandler handler) throws IOException, ElfException, DwarfException {
        Intrinsics.checkParameterIsNotNull(input, "input");
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        Closeable closeable = new ByteReader(new RandomAccessFileInputStream(input));
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteReader reader = (ByteReader)closeable;
            boolean bl2 = false;
            ElfParserKt.parseElf(reader, handler);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private static final void parseElf(ByteReader reader, ElfHandler handler) throws IOException, ElfException, DwarfException {
        reader.seek(0L);
        Log.INSTANCE.debug("Reading elf file ident");
        ElfFileIdent elfFileIdent = ElfFileIdentKt.readElfFileIdent(reader);
        Log.INSTANCE.debug("Setting byte order " + elfFileIdent.getElfData().getByteOrder());
        reader.setByteOrder(elfFileIdent.getElfData().getByteOrder());
        ElfParserKt.parseElf(reader, elfFileIdent, handler);
    }

    private static final void parseElf(ByteReader reader, ElfFileIdent ident, ElfHandler handler) throws IOException, ElfException, DwarfException {
        Log.INSTANCE.debug("Reading elf file header");
        ElfFileHeader header = ElfFileHeaderKt.readElfFileHeader(reader, ident);
        handler.processElfHeader(header);
        Log.INSTANCE.debug("Reading elf section headers");
        ElfSectionHeaders sectionHeaders = ElfSectionHeadersKt.parseElfSectionHeaders(reader, header);
        handler.processSectionHeaders(sectionHeaders);
        Log.INSTANCE.debug("Reading elf build id");
        ElfProgramHeaders programHeaders = ElfProgramHeadersKt.parseElfProgramHeaders(reader, header);
        Object object = ElfUuidKt.parseElfBuildId(reader, sectionHeaders, programHeaders);
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = object;
        boolean bl3 = false;
        handler.processElfBuildId(it);
        Log.INSTANCE.debug("Reading arm version");
        String string = ElfArmVersionKt.parseArmVersion(reader, header, sectionHeaders);
        if (string != null) {
            object = string;
            bl = false;
            bl2 = false;
            Object armVersion = object;
            boolean bl4 = false;
            handler.processArmVersion((String)armVersion);
        } else {
            Log.INSTANCE.debug("Arm version not found");
        }
        ElfParserKt.parseElfSymbols(reader, header, sectionHeaders, handler);
    }

    private static final void parseElfSymbols(ByteReader reader, ElfFileHeader elfFileHeader, ElfSectionHeaders sectionHeaders, ElfHandler handler) throws IOException, DwarfException {
        handler.startProcessingSymbols();
        Log.INSTANCE.debug("Reading elf symbols");
        handler.processElfSymbols(ElfSymbolKt.parseElfSymbols(reader, elfFileHeader, sectionHeaders));
        Log.INSTANCE.debug("Reading debug elf section headers");
        DebugElfSectionHeaders debugElfSectionHeaders = DebugElfSectionHeaders.Companion.from(sectionHeaders);
        if (debugElfSectionHeaders != null) {
            DebugElfSectionHeaders debugElfSectionHeaders2 = debugElfSectionHeaders;
            boolean bl = false;
            boolean bl2 = false;
            DebugElfSectionHeaders debugHeaders = debugElfSectionHeaders2;
            boolean bl3 = false;
            DwarfParserKt.parseDwarf(reader, handler, elfFileHeader.getIdent().getElfData().getByteOrder(), debugHeaders);
        } else {
            Log.INSTANCE.debug("Debug elf section headers not found");
        }
        handler.endProcessingSymbols();
    }
}

