/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.io;

import com.yandex.android.appmetrica.ndk.io.SeekableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0012J\u0010\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u0012J\u0010\u0010\u001b\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ(\u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0006\u0010\"\u001a\u00020\u0012J\u0010\u0010#\u001a\u00020$2\b\b\u0002\u0010\u0018\u001a\u00020\u0012J\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/yandex/android/appmetrica/ndk/io/ByteReader;", "Ljava/io/Closeable;", "source", "Lcom/yandex/android/appmetrica/ndk/io/SeekableInputStream;", "(Lcom/yandex/android/appmetrica/ndk/io/SeekableInputStream;)V", "buffer", "Ljava/nio/ByteBuffer;", "bytes", "", "close", "", "getByteOrder", "Ljava/nio/ByteOrder;", "getCurrentOffset", "", "padBytes", "data", "dataLen", "", "totalWidth", "order", "readByte", "", "readBytes", "numBytes", "readBytesWithBlockSize", "readInt", "readLong", "readNullTerminatedString", "", "charset", "Ljava/nio/charset/Charset;", "readNumber", "width", "readSLEB128", "readShort", "", "readULEB128", "seek", "offset", "setByteOrder", "appmetrica-build-plugin"})
public final class ByteReader
implements Closeable {
    private final byte[] bytes;
    private final ByteBuffer buffer;
    private final SeekableInputStream source;

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    public final long getCurrentOffset() {
        return this.source.getCurrentOffset();
    }

    @NotNull
    public final ByteOrder getByteOrder() {
        ByteOrder byteOrder = this.buffer.order();
        if (byteOrder == null) {
            Intrinsics.throwNpe();
        }
        return byteOrder;
    }

    public final void setByteOrder(@NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(order, "order");
        this.buffer.order(order);
    }

    public final void seek(long offset) throws IOException {
        this.source.seek(offset);
    }

    @NotNull
    public final byte[] readBytes(int numBytes) throws IOException {
        byte[] bytes = new byte[numBytes];
        this.source.readFully(bytes, 0, bytes.length);
        return bytes;
    }

    public final byte readByte() throws IOException {
        int b = this.source.read();
        if (b < 0) {
            throw (Throwable)new EOFException();
        }
        return (byte)(b & 0xFF);
    }

    public final short readShort(int numBytes) throws IOException {
        ByteOrder byteOrder = this.buffer.order();
        Intrinsics.checkExpressionValueIsNotNull(byteOrder, "buffer.order()");
        this.buffer.put(this.readNumber(this.bytes, numBytes, 2, byteOrder));
        this.buffer.flip();
        short answer = this.buffer.getShort();
        this.buffer.clear();
        return answer;
    }

    public static /* synthetic */ short readShort$default(ByteReader byteReader, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return byteReader.readShort(n);
    }

    public final int readInt(int numBytes) throws IOException {
        ByteOrder byteOrder = this.buffer.order();
        Intrinsics.checkExpressionValueIsNotNull(byteOrder, "buffer.order()");
        this.buffer.put(this.readNumber(this.bytes, numBytes, 4, byteOrder));
        this.buffer.flip();
        int answer = this.buffer.getInt();
        this.buffer.clear();
        return answer;
    }

    public static /* synthetic */ int readInt$default(ByteReader byteReader, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return byteReader.readInt(n);
    }

    public final long readLong(int numBytes) throws IOException {
        ByteOrder byteOrder = this.buffer.order();
        Intrinsics.checkExpressionValueIsNotNull(byteOrder, "buffer.order()");
        this.buffer.put(this.readNumber(this.bytes, numBytes, 8, byteOrder));
        this.buffer.flip();
        long answer = this.buffer.getLong();
        this.buffer.clear();
        return answer;
    }

    public static /* synthetic */ long readLong$default(ByteReader byteReader, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        return byteReader.readLong(n);
    }

    @NotNull
    public final String readNullTerminatedString(@NotNull Charset charset) throws IOException {
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int b = this.source.read();
        while (b != 0) {
            if (b < 0) {
                throw (Throwable)new EOFException();
            }
            bos.write(b);
            b = this.source.read();
        }
        byte[] byArray = bos.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "bos.toByteArray()");
        byte[] byArray2 = byArray;
        boolean bl = false;
        return new String(byArray2, charset);
    }

    public final int readULEB128() throws IOException {
        int value = 0;
        int shift = 0;
        while (true) {
            byte b = this.readByte();
            value |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return value;
    }

    public final int readSLEB128() throws IOException {
        int value = 0;
        int shift = 0;
        int size = 0;
        byte b = 0;
        do {
            b = this.readByte();
            ++size;
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        if (shift < size * 8 && (b & 0x40) != 0) {
            value |= -(1 << shift);
        }
        return value;
    }

    @NotNull
    public final byte[] readBytesWithBlockSize() throws IOException {
        return this.readBytes(this.readULEB128());
    }

    @NotNull
    public final byte[] readBytesWithBlockSize(int numBytes) throws IOException {
        return this.readBytes(this.readInt(numBytes));
    }

    private final byte[] readNumber(byte[] buffer, int numBytes, int width, ByteOrder order) throws IOException {
        if (numBytes > width) {
            throw (Throwable)new IllegalArgumentException("Requested number of bytes (" + numBytes + ") was greater than available bytes (" + width + ").");
        }
        this.source.readFully(buffer, 0, numBytes);
        return this.padBytes(buffer, numBytes, width, order);
    }

    private final byte[] padBytes(byte[] data, int dataLen, int totalWidth, ByteOrder order) {
        byte[] padded = new byte[totalWidth];
        int dest = Intrinsics.areEqual(order, ByteOrder.BIG_ENDIAN) ? totalWidth - dataLen : 0;
        System.arraycopy(data, 0, padded, dest, dataLen);
        return padded;
    }

    public ByteReader(@NotNull SeekableInputStream source) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        this.source = source;
        this.bytes = new byte[64];
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.bytes.length);
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "ByteBuffer.allocate(bytes.size)");
        this.buffer = byteBuffer;
    }
}

