/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.android.appmetrica.ndk.io;

import com.yandex.android.appmetrica.ndk.io.SeekableInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\"\u0010\u0015\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J \u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/yandex/android/appmetrica/ndk/io/RandomAccessFileInputStream;", "Lcom/yandex/android/appmetrica/ndk/io/SeekableInputStream;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "buffer", "", "bufferCount", "", "bufferPos", "Ljava/io/RandomAccessFile;", "filePointer", "", "close", "", "fillBuffer", "getCurrentOffset", "read", "bytes", "off", "len", "readFromFile", "offset", "readFully", "length", "readOnce", "seek", "skip", "n", "validateOpen", "appmetrica-build-plugin"})
public final class RandomAccessFileInputStream
extends SeekableInputStream {
    private RandomAccessFile file;
    private final byte[] buffer;
    private long filePointer;
    private int bufferPos;
    private int bufferCount;

    @Override
    public long getCurrentOffset() throws IOException {
        this.validateOpen();
        int remaining = this.bufferCount - this.bufferPos;
        int n = 0;
        long l = this.filePointer;
        boolean bl = false;
        int n2 = Math.max(remaining, n);
        return l - (long)n2;
    }

    @Override
    public void seek(long offset) throws IOException {
        this.validateOpen();
        if (offset < 0L) {
            throw (Throwable)new IOException("Seek offset must be greater than 0");
        }
        long beginOffset = this.filePointer - (long)this.bufferCount;
        long l = offset;
        if (beginOffset <= l && this.filePointer > l) {
            this.bufferPos = (int)(offset - beginOffset);
        } else {
            RandomAccessFile randomAccessFile = this.file;
            if (randomAccessFile == null) {
                Intrinsics.throwNpe();
            }
            randomAccessFile.seek(offset);
            this.bufferCount = 0;
            RandomAccessFile randomAccessFile2 = this.file;
            if (randomAccessFile2 == null) {
                Intrinsics.throwNpe();
            }
            this.filePointer = randomAccessFile2.getFilePointer();
        }
    }

    @Override
    public void readFully(@NotNull byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.validateOpen();
        int totalBytes = 0;
        do {
            if ((bytesRead = this.read(buffer, offset + totalBytes, length - totalBytes)) >= 0) continue;
            throw (Throwable)new EOFException();
        } while ((totalBytes += bytesRead) < length);
    }

    @Override
    public int read() throws IOException {
        this.validateOpen();
        if (this.bufferPos >= this.bufferCount) {
            this.fillBuffer();
            if (this.bufferPos >= this.bufferCount) {
                return -1;
            }
        }
        int n = this.bufferPos;
        this.bufferPos = n + 1;
        return this.buffer[n] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        this.validateOpen();
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) throws IOException {
        int bytesRead;
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        int n = off;
        if (0 > n || bytes.length < n || len < 0 || 0 > (n = off + len) || bytes.length < n) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return len;
        }
        this.validateOpen();
        int totalBytes = 0;
        do {
            if ((bytesRead = this.readOnce(bytes, off + totalBytes, len - totalBytes)) > 0) continue;
            if (totalBytes != 0) break;
            totalBytes = bytesRead;
            break;
        } while ((totalBytes += bytesRead) < len);
        return totalBytes;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.validateOpen();
        int remaining = this.bufferCount - this.bufferPos;
        long skip = 0L;
        if (n <= (long)remaining) {
            this.bufferPos += (int)n;
            skip = n;
        } else {
            long fileLen;
            long newPos;
            long pos = this.getCurrentOffset();
            RandomAccessFile randomAccessFile = this.file;
            if (randomAccessFile == null) {
                Intrinsics.throwNpe();
            }
            if ((newPos = pos + n) > (fileLen = randomAccessFile.length())) {
                newPos = fileLen;
            }
            this.seek(newPos);
            skip = newPos - pos;
        }
        return skip;
    }

    @Override
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.file;
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        this.file = null;
    }

    private final int readOnce(byte[] bytes, int offset, int len) throws IOException {
        int remaining = this.bufferCount - this.bufferPos;
        if (remaining <= 0) {
            if (len >= this.buffer.length) {
                return this.readFromFile(bytes, offset, len);
            }
            this.fillBuffer();
            remaining = this.bufferCount - this.bufferPos;
            if (remaining <= 0) {
                return -1;
            }
        }
        int numBytesRead = remaining < len ? remaining : len;
        System.arraycopy(this.buffer, this.bufferPos, bytes, offset, numBytesRead);
        this.bufferPos += numBytesRead;
        return numBytesRead;
    }

    private final void fillBuffer() throws IOException {
        this.bufferPos = 0;
        this.bufferCount = 0;
        int numRead = this.readFromFile(this.buffer, 0, this.buffer.length);
        if (numRead > 0) {
            this.bufferCount = numRead;
        }
    }

    private final int readFromFile(byte[] bytes, int offset, int len) throws IOException {
        RandomAccessFile randomAccessFile = this.file;
        if (randomAccessFile == null) {
            Intrinsics.throwNpe();
        }
        int bytesRead = randomAccessFile.read(bytes, offset, len);
        RandomAccessFile randomAccessFile2 = this.file;
        if (randomAccessFile2 == null) {
            Intrinsics.throwNpe();
        }
        this.filePointer = randomAccessFile2.getFilePointer();
        return bytesRead;
    }

    private final void validateOpen() throws IOException {
        if (this.file == null) {
            throw (Throwable)new IOException("Stream closed.");
        }
    }

    public RandomAccessFileInputStream(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull(file, "file");
        this.file = new RandomAccessFile(file, "r");
        this.buffer = new byte[8192];
        RandomAccessFile randomAccessFile = this.file;
        if (randomAccessFile == null) {
            Intrinsics.throwNpe();
        }
        this.filePointer = randomAccessFile.getFilePointer();
    }
}

